/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.concurrent.jdk8backported.BoundedEquivalentConcurrentHashMapV8;

public final class InfinispanPolicy
implements Policy {
    private final Map<Object, Object> cache;
    private final PolicyStats policyStats = new PolicyStats("product.Infinispan");
    private final int maximumSize;

    public InfinispanPolicy(Config config) {
        InfinispanSettings settings = new InfinispanSettings(config);
        this.cache = new BoundedEquivalentConcurrentHashMapV8((long)settings.maximumSize(), settings.policy(), BoundedEquivalentConcurrentHashMapV8.getNullEvictionListener(), (Equivalence)AnyEquivalence.getInstance(), (Equivalence)AnyEquivalence.getInstance());
        this.maximumSize = settings.maximumSize();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new InfinispanPolicy(config));
    }

    @Override
    public void record(long key) {
        Object value = this.cache.get(key);
        if (value == null) {
            this.policyStats.recordMiss();
            if (this.cache.size() == this.maximumSize) {
                this.policyStats.recordEviction();
            }
            this.cache.put(key, key);
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class InfinispanSettings
    extends BasicSettings {
        public InfinispanSettings(Config config) {
            super(config);
        }

        public BoundedEquivalentConcurrentHashMapV8.Eviction policy() {
            return BoundedEquivalentConcurrentHashMapV8.Eviction.valueOf((String)this.config().getString("infinispan.policy").toUpperCase());
        }
    }
}

