/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.trivago.triava.tcache.TCacheFactory;
import com.trivago.triava.tcache.core.EvictionInterface;
import com.trivago.triava.tcache.eviction.Cache;
import com.trivago.triava.tcache.eviction.LFUEviction;
import com.trivago.triava.tcache.eviction.LRUEviction;
import com.typesafe.config.Config;
import java.util.Set;

public final class TCachePolicy
implements Policy {
    private final Cache<Object, Object> cache;
    private final PolicyStats policyStats;
    private final int maximumSize;

    public TCachePolicy(Config config) {
        TCacheSettings settings = new TCacheSettings(config);
        this.maximumSize = settings.maximumSize();
        this.policyStats = new PolicyStats("product.TCache");
        this.cache = TCacheFactory.standardFactory().builder().setEvictionClass(settings.policy()).setExpectedMapSize(this.maximumSize).setStatistics(true).build();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new TCachePolicy(config));
    }

    @Override
    public void record(long key) {
        Object value = this.cache.get((Object)key);
        if (value == null) {
            this.policyStats.recordMiss();
            if (this.cache.size() == this.maximumSize) {
                this.policyStats.recordEviction();
            }
            this.cache.put((Object)key, (Object)key);
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        this.policyStats.addEvictions(this.cache.statistics().getEvictionCount());
    }

    static final class TCacheSettings
    extends BasicSettings {
        public TCacheSettings(Config config) {
            super(config);
        }

        public <K, V> EvictionInterface<K, V> policy() {
            String policy;
            switch (policy = this.config().getString("tcache.policy").toLowerCase()) {
                case "lfu": {
                    return new LFUEviction();
                }
                case "lru": {
                    return new LRUEviction();
                }
            }
            throw new IllegalArgumentException("Unknown policy type: " + policy);
        }
    }
}

