/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sampled;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admission;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Ticker;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class SamplingPolicy
implements Policy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final EvictionPolicy policy;
    private final Sample sampleStrategy;
    private final Admittor admittor;
    private final int maximumSize;
    private final int sampleSize;
    private final Ticker ticker;
    private final Random random;
    private final Node[] table;

    public SamplingPolicy(Admission admission, EvictionPolicy policy, Config config) {
        String name = admission.format("sampled." + policy.label());
        SamplingSettings settings = new SamplingSettings(config);
        this.sampleStrategy = settings.sampleStrategy();
        this.random = new Random(settings.randomSeed());
        this.data = new Long2ObjectOpenHashMap();
        this.maximumSize = settings.maximumSize();
        this.policyStats = new PolicyStats(name);
        this.sampleSize = settings.sampleSize();
        this.table = new Node[this.maximumSize + 1];
        this.admittor = admission.from(config);
        this.ticker = new CountTicker();
        this.policy = policy;
    }

    public static Set<Policy> policies(Config config, EvictionPolicy policy) {
        BasicSettings settings = new BasicSettings(config);
        return settings.admission().stream().map(admission -> new SamplingPolicy((Admission)((Object)admission), policy, config)).collect(Collectors.toSet());
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(long key) {
        Node node = (Node)this.data.get(key);
        long now = this.ticker.read();
        this.admittor.record(key);
        if (node == null) {
            node = new Node(key, this.data.size(), now);
            this.policyStats.recordOperation();
            this.policyStats.recordMiss();
            this.table[((Node)node).index] = node;
            this.data.put(key, (Object)node);
            this.evict(node);
        } else {
            this.policyStats.recordOperation();
            this.policyStats.recordHit();
            node.accessTime = now;
            node.frequency++;
        }
    }

    private void evict(Node candidate) {
        if (this.data.size() > this.maximumSize) {
            List<Node> sample = this.policy == EvictionPolicy.RANDOM ? Arrays.asList(this.table) : this.sampleStrategy.sample(this.table, candidate, this.sampleSize, this.random, this.policyStats);
            Node victim = this.policy.select(sample, this.random);
            this.policyStats.recordEviction();
            if (this.admittor.admit(candidate.key, victim.key)) {
                this.removeFromTable(victim);
                this.data.remove(victim.key);
            } else {
                this.removeFromTable(candidate);
                this.data.remove(candidate.key);
            }
        }
    }

    private void removeFromTable(Node node) {
        int last = this.data.size() - 1;
        this.table[((Node)node).index] = this.table[last];
        this.table[node.index].index = node.index;
        this.table[last] = null;
    }

    static final class SamplingSettings
    extends BasicSettings {
        public SamplingSettings(Config config) {
            super(config);
        }

        public int sampleSize() {
            return this.config().getInt("sampling.size");
        }

        public Sample sampleStrategy() {
            return Sample.valueOf(this.config().getString("sampling.strategy").toUpperCase());
        }
    }

    static final class CountTicker
    extends Ticker {
        private long tick;

        CountTicker() {
        }

        public long read() {
            return ++this.tick;
        }
    }

    static final class Node {
        private final long key;
        private final long insertionTime;
        private long accessTime;
        private int frequency;
        private int index;

        public Node(long key, int index, long tick) {
            this.insertionTime = tick;
            this.accessTime = tick;
            this.index = index;
            this.key = key;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("index", this.index).toString();
        }
    }

    public static enum EvictionPolicy {
        FIFO{

            @Override
            Node select(List<Node> sample, Random random) {
                return (Node)sample.stream().min((first, second) -> Long.compare(((Node)first).insertionTime, ((Node)second).insertionTime)).get();
            }
        }
        ,
        LRU{

            @Override
            Node select(List<Node> sample, Random random) {
                return (Node)sample.stream().min((first, second) -> Long.compare(((Node)first).accessTime, ((Node)second).accessTime)).get();
            }
        }
        ,
        MRU{

            @Override
            Node select(List<Node> sample, Random random) {
                return (Node)sample.stream().max((first, second) -> Long.compare(((Node)first).accessTime, ((Node)second).accessTime)).get();
            }
        }
        ,
        LFU{

            @Override
            Node select(List<Node> sample, Random random) {
                return (Node)sample.stream().min((first, second) -> Long.compare(((Node)first).frequency, ((Node)second).frequency)).get();
            }
        }
        ,
        MFU{

            @Override
            Node select(List<Node> sample, Random random) {
                return (Node)sample.stream().max((first, second) -> Long.compare(((Node)first).frequency, ((Node)second).frequency)).get();
            }
        }
        ,
        RANDOM{

            @Override
            Node select(List<Node> sample, Random random) {
                int victim = random.nextInt(sample.size());
                return sample.get(victim);
            }
        };


        public String label() {
            return StringUtils.capitalize((String)this.name().toLowerCase());
        }

        abstract Node select(List<Node> var1, Random var2);
    }

    public static enum Sample {
        GUESS{

            @Override
            public <E> List<E> sample(E[] elements, E candidate, int sampleSize, Random random, PolicyStats policyStats) {
                ArrayList<E> sample = new ArrayList<E>(sampleSize);
                policyStats.addOperations(sampleSize);
                for (int i = 0; i < sampleSize; ++i) {
                    int index = random.nextInt(elements.length);
                    if (elements[index] == candidate) {
                        --i;
                    }
                    sample.add(elements[index]);
                }
                return sample;
            }
        }
        ,
        RESERVOIR{

            @Override
            public <E> List<E> sample(E[] elements, E candidate, int sampleSize, Random random, PolicyStats policyStats) {
                ArrayList<E> sample = new ArrayList<E>(sampleSize);
                policyStats.addOperations(elements.length);
                int count = 0;
                for (E e : elements) {
                    if (e == candidate) continue;
                    ++count;
                    if (sample.size() <= sampleSize) {
                        sample.add(e);
                        continue;
                    }
                    int index = random.nextInt(count);
                    if (index >= sampleSize) continue;
                    sample.set(index, e);
                }
                return sample;
            }
        }
        ,
        SHUFFLE{

            @Override
            public <E> List<E> sample(E[] elements, E candidate, int sampleSize, Random random, PolicyStats policyStats) {
                ArrayList<E> sample = new ArrayList<E>(Arrays.asList(elements));
                policyStats.addOperations(elements.length);
                Collections.shuffle(sample, random);
                sample.remove(candidate);
                return sample.subList(0, sampleSize);
            }
        };


        abstract <E> List<E> sample(E[] var1, E var2, int var3, Random var4, PolicyStats var5);
    }
}

