/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.admission.TinyLfu;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class WindowTinyLfuPolicy
implements Policy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final int recencyMoveDistance;
    private final Admittor admittor;
    private final int maximumSize;
    private final Node headEden;
    private final Node headProbation;
    private final Node headProtected;
    private final int maxEden;
    private final int maxProtected;
    private int sizeEden;
    private int sizeProtected;
    private int mainRecencyCounter;

    public WindowTinyLfuPolicy(double percentMain, WindowTinyLfuSettings settings) {
        String name = String.format("sketch.WindowTinyLfu (%.0f%%)", 100.0 * (1.0 - percentMain));
        int maxMain = (int)((double)settings.maximumSize() * percentMain);
        this.recencyMoveDistance = (int)((double)maxMain * settings.percentFastPath());
        this.maxProtected = (int)((double)maxMain * settings.percentMainProtected());
        this.maxEden = settings.maximumSize() - maxMain;
        this.admittor = new TinyLfu(settings.config());
        this.data = new Long2ObjectOpenHashMap();
        this.maximumSize = settings.maximumSize();
        this.policyStats = new PolicyStats(name);
        this.headProtected = new Node();
        this.headProbation = new Node();
        this.headEden = new Node();
    }

    public static Set<Policy> policies(Config config) {
        WindowTinyLfuSettings settings = new WindowTinyLfuSettings(config);
        return settings.percentMain().stream().map(percentMain -> new WindowTinyLfuPolicy((double)percentMain, settings)).collect(Collectors.toSet());
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node == null) {
            this.onMiss(key);
            this.policyStats.recordMiss();
        } else if (node.status == Status.EDEN) {
            this.onEdenHit(node);
            this.policyStats.recordHit();
        } else if (node.status == Status.PROBATION) {
            this.onProbationHit(node);
            this.policyStats.recordHit();
        } else if (node.status == Status.PROTECTED) {
            this.onProtectedHit(node);
            this.policyStats.recordHit();
        } else {
            throw new IllegalStateException();
        }
    }

    private void onMiss(long key) {
        this.admittor.record(key);
        Node node = new Node(key, Status.EDEN);
        node.appendToTail(this.headEden);
        this.data.put(key, (Object)node);
        ++this.sizeEden;
        this.evict();
    }

    private void onEdenHit(Node node) {
        this.admittor.record(node.key);
        node.moveToTail(this.headEden);
    }

    private void onProbationHit(Node node) {
        this.admittor.record(node.key);
        node.remove();
        node.status = Status.PROTECTED;
        node.appendToTail(this.headProtected);
        node.recencyMove = ++this.mainRecencyCounter;
        ++this.sizeProtected;
        if (this.sizeProtected > this.maxProtected) {
            Node demote = this.headProtected.next;
            demote.remove();
            demote.status = Status.PROBATION;
            demote.appendToTail(this.headProbation);
            --this.sizeProtected;
        }
    }

    private void onProtectedHit(Node node) {
        if (node.recencyMove <= this.mainRecencyCounter - this.recencyMoveDistance) {
            this.admittor.record(node.key);
            node.moveToTail(this.headProtected);
            node.recencyMove = ++this.mainRecencyCounter;
        }
    }

    private void evict() {
        if (this.sizeEden <= this.maxEden) {
            return;
        }
        Node candidate = this.headEden.next;
        --this.sizeEden;
        candidate.remove();
        candidate.status = Status.PROBATION;
        candidate.appendToTail(this.headProbation);
        if (this.data.size() > this.maximumSize) {
            Node victim = this.headProbation.next;
            Node evict = this.admittor.admit(candidate.key, victim.key) ? victim : candidate;
            this.data.remove(evict.key);
            evict.remove();
            this.policyStats.recordEviction();
        }
    }

    @Override
    public void finished() {
        long edenSize = this.data.values().stream().filter(n -> n.status == Status.EDEN).count();
        long probationSize = this.data.values().stream().filter(n -> n.status == Status.PROBATION).count();
        long protectedSize = this.data.values().stream().filter(n -> n.status == Status.PROTECTED).count();
        Preconditions.checkState((edenSize == (long)this.sizeEden ? 1 : 0) != 0);
        Preconditions.checkState((protectedSize == (long)this.sizeProtected ? 1 : 0) != 0);
        Preconditions.checkState((probationSize == (long)this.data.size() - edenSize - protectedSize ? 1 : 0) != 0);
        Preconditions.checkState((this.data.size() <= this.maximumSize ? 1 : 0) != 0);
    }

    static final class WindowTinyLfuSettings
    extends BasicSettings {
        public WindowTinyLfuSettings(Config config) {
            super(config);
        }

        public List<Double> percentMain() {
            return this.config().getDoubleList("window-tiny-lfu.percent-main");
        }

        public double percentMainProtected() {
            return this.config().getDouble("window-tiny-lfu.percent-main-protected");
        }

        public double percentFastPath() {
            return this.config().getDouble("window-tiny-lfu.percent-fast-path");
        }
    }

    static final class Node {
        final long key;
        int recencyMove;
        Status status;
        Node prev;
        Node next;

        public Node() {
            this.key = Integer.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        public Node(long key, Status status) {
            this.status = status;
            this.key = key;
        }

        public void moveToTail(Node head) {
            this.remove();
            this.appendToTail(head);
        }

        public void appendToTail(Node head) {
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = null;
            this.next = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("status", (Object)this.status).add("move", this.recencyMove).toString();
        }
    }

    static enum Status {
        EDEN,
        PROBATION,
        PROTECTED;

    }
}

