/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.two_queue;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Set;

public final class TwoQueuePolicy
implements Policy {
    private static final Node UNLINKED = new Node();
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final int maximumSize;
    private int sizeIn;
    private final int maxIn;
    private final Node headIn;
    private int sizeOut;
    private final int maxOut;
    private final Node headOut;
    private int sizeMain;
    private final Node headMain;

    public TwoQueuePolicy(Config config) {
        TwoQueueSettings settings = new TwoQueueSettings(config);
        this.headIn = new Node();
        this.headOut = new Node();
        this.headMain = new Node();
        this.maximumSize = settings.maximumSize();
        this.data = new Long2ObjectOpenHashMap();
        this.maxIn = (int)((double)this.maximumSize * settings.percentIn());
        this.policyStats = new PolicyStats("two-queue.TwoQueue");
        this.maxOut = (int)((double)this.maximumSize * settings.percentOut());
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new TwoQueuePolicy(config));
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node != null) {
            switch (node.type) {
                case MAIN: {
                    node.moveToTail(this.headMain);
                    this.policyStats.recordHit();
                    return;
                }
                case OUT: {
                    node.remove();
                    --this.sizeOut;
                    this.reclaimfor(node);
                    node.appendToTail(this.headMain);
                    node.type = QueueType.MAIN;
                    ++this.sizeMain;
                    this.policyStats.recordMiss();
                    return;
                }
                case IN: {
                    this.policyStats.recordHit();
                    return;
                }
            }
            throw new IllegalStateException();
        }
        node = new Node(key);
        node.type = QueueType.IN;
        this.reclaimfor(node);
        node.appendToTail(this.headIn);
        ++this.sizeIn;
        this.policyStats.recordMiss();
    }

    private void reclaimfor(Node node) {
        if (this.sizeMain + this.sizeIn < this.maximumSize) {
            this.data.put(node.key, (Object)node);
        } else if (this.sizeIn > this.maxIn) {
            Node n = this.headIn.next;
            n.remove();
            --this.sizeIn;
            n.appendToTail(this.headOut);
            n.type = QueueType.OUT;
            ++this.sizeOut;
            if (this.sizeOut > this.maxOut) {
                this.policyStats.recordEviction();
                Node victim = this.headOut.next;
                this.data.remove(victim.key);
                victim.remove();
                --this.sizeOut;
            }
            this.data.put(node.key, (Object)node);
        } else {
            this.policyStats.recordEviction();
            Node victim = this.headMain.next;
            this.data.remove(victim.key);
            victim.remove();
            --this.sizeMain;
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class TwoQueueSettings
    extends BasicSettings {
        public TwoQueueSettings(Config config) {
            super(config);
        }

        public double percentIn() {
            return this.config().getDouble("two-queue.percent-in");
        }

        public double percentOut() {
            return this.config().getDouble("two-queue.percent-out");
        }
    }

    static final class Node {
        final long key;
        Node prev;
        Node next;
        QueueType type;

        Node() {
            this.key = Long.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        Node(long key) {
            this.key = key;
            this.prev = UNLINKED;
            this.next = UNLINKED;
        }

        public void appendToTail(Node head) {
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void moveToTail(Node head) {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = head;
            this.prev = head.prev;
            head.prev = this;
            this.prev.next = this;
        }

        public void remove() {
            Preconditions.checkState((this.key != Long.MIN_VALUE ? 1 : 0) != 0);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = this.next = UNLINKED;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("type", (Object)this.type).toString();
        }
    }

    static enum QueueType {
        MAIN,
        IN,
        OUT;

    }
}

