/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.report.Reporter;
import com.google.common.io.Files;
import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class TextReporter
implements Reporter {
    private static final String[] HEADERS = new String[]{"Policy", "Hit rate", "Hits", "Misses", "Requests", "Evictions", "Steps", "Time"};
    private final List<PolicyStats> results;
    private final BasicSettings settings;

    public TextReporter(Config config) {
        this.settings = new BasicSettings(config);
        this.results = new ArrayList<PolicyStats>();
    }

    protected String[] headers() {
        return (String[])HEADERS.clone();
    }

    @Override
    public void add(PolicyStats policyStats) {
        this.results.add(policyStats);
    }

    @Override
    public void print() throws IOException {
        this.results.sort(this.comparator());
        String report = this.assemble(this.results);
        String output = this.settings.report().output();
        if (output.equalsIgnoreCase("console")) {
            System.out.println(report);
        } else {
            File file = Paths.get(output, new String[0]).toFile();
            Files.write((CharSequence)report, (File)file, (Charset)StandardCharsets.UTF_8);
        }
    }

    protected abstract String assemble(List<PolicyStats> var1);

    private Comparator<PolicyStats> comparator() {
        Comparator<PolicyStats> comparator = this.makeComparator();
        return this.settings.report().ascending() ? comparator : comparator.reversed();
    }

    private Comparator<PolicyStats> makeComparator() {
        switch (this.settings.report().sortBy().toLowerCase()) {
            case "policy": {
                return Comparator.comparing(PolicyStats::name);
            }
            case "hit rate": {
                return Comparator.comparingDouble(PolicyStats::hitRate);
            }
            case "hits": {
                return Comparator.comparingLong(PolicyStats::hitCount);
            }
            case "misses": {
                return Comparator.comparingLong(PolicyStats::missCount);
            }
            case "evictions": {
                return Comparator.comparingLong(PolicyStats::evictionCount);
            }
            case "steps": {
                return Comparator.comparingLong(PolicyStats::operationCount);
            }
            case "time": {
                return Comparator.comparingLong(stats -> stats.stopwatch().elapsed(TimeUnit.NANOSECONDS));
            }
        }
        throw new IllegalArgumentException("Unknown sort order: " + this.settings.report().sortBy());
    }
}

