/*
 * Copyright 2017 Ben Manes. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.gradle;

import java.io.IOException;
import java.math.BigInteger;
import java.util.stream.LongStream;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader.KeyOnlyTraceReader;

/**
 * A reader for the Gradle Build Cache trace files provided by the Gradle team.
 *
 * @author ben.manes@gmail.com (Ben Manes)
 */
public final class GradleTraceReader extends TextTraceReader implements KeyOnlyTraceReader {

  public GradleTraceReader(String filePath) {
    super(filePath);
  }

  @Override
  public LongStream keys() throws IOException {
    return lines()
        .map(uuid -> new BigInteger(uuid, 16))
        .mapToLong(num -> num.shiftRight(64).longValue() ^ num.longValue());
  }
}
