/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import java.util.Set;

public final class GuavaPolicy
implements Policy {
    private final Cache<Long, AccessEvent> cache;
    private final PolicyStats policyStats = new PolicyStats("product.Guava");

    public GuavaPolicy(Config config, Set<Policy.Characteristic> characteristics) {
        BasicSettings settings = new BasicSettings(config);
        CacheBuilder builder = CacheBuilder.newBuilder().removalListener(notification -> this.policyStats.recordEviction());
        if (characteristics.contains((Object)Policy.Characteristic.WEIGHTED)) {
            builder.maximumWeight(settings.maximumSize());
            builder.weigher((key, value) -> value.weight());
        } else {
            builder.maximumSize(settings.maximumSize());
        }
        this.cache = builder.build();
    }

    public static Set<Policy> policies(Config config, Set<Policy.Characteristic> characteristics) {
        return ImmutableSet.of((Object)new GuavaPolicy(config, characteristics));
    }

    @Override
    public Set<Policy.Characteristic> characteristics() {
        return Sets.immutableEnumSet((Enum)Policy.Characteristic.WEIGHTED, (Enum[])new Policy.Characteristic[0]);
    }

    @Override
    public void record(AccessEvent event) {
        AccessEvent value = (AccessEvent)this.cache.getIfPresent((Object)event.key());
        if (value == null) {
            this.cache.put((Object)event.key(), (Object)event);
            this.policyStats.recordWeightedMiss(event.weight());
        } else {
            this.policyStats.recordWeightedHit(event.weight());
            if (event.weight() != value.weight()) {
                this.cache.put((Object)event.key(), (Object)event);
            }
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }
}

