/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import java.util.Locale;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;

@Policy.PolicySpec(name="product.ExpiringMap")
public final class ExpiringMapPolicy
implements Policy.KeyOnlyPolicy {
    private final ExpiringMap<Object, Object> cache;
    private final PolicyStats policyStats;

    public ExpiringMapPolicy(Config config) {
        ExpiringMapSettings settings = new ExpiringMapSettings(config);
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.cache = ExpiringMap.builder().maxSize(Ints.checkedCast((long)settings.maximumSize())).expirationPolicy(settings.policy()).build();
    }

    @Override
    public void record(long key) {
        Object value = this.cache.get((Object)key);
        if (value == null) {
            if (this.cache.size() == this.cache.getMaxSize()) {
                this.policyStats.recordEviction();
            }
            this.cache.put((Object)key, (Object)key);
            this.policyStats.recordMiss();
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class ExpiringMapSettings
    extends BasicSettings {
        public ExpiringMapSettings(Config config) {
            super(config);
        }

        public ExpirationPolicy policy() {
            String policy;
            switch (policy = this.config().getString("expiring-map.policy").toLowerCase(Locale.US)) {
                case "fifo": {
                    return ExpirationPolicy.CREATED;
                }
                case "lru": {
                    return ExpirationPolicy.ACCESSED;
                }
            }
            throw new IllegalArgumentException("Unknown policy type: " + policy);
        }
    }
}

