/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report.table;

import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.report.Metrics;
import com.github.benmanes.caffeine.cache.simulator.report.TextReporter;
import com.jakewharton.fliptables.FlipTable;
import com.typesafe.config.Config;
import java.util.List;
import java.util.Set;

public final class TableReporter
extends TextReporter {
    public TableReporter(Config config, Set<Policy.Characteristic> characteristics) {
        super(config, characteristics);
    }

    @Override
    protected String assemble(List<PolicyStats> results) {
        String[][] data = new String[results.size()][this.headers().size()];
        for (int i = 0; i < results.size(); ++i) {
            PolicyStats policyStats = results.get(i);
            data[i] = (String[])this.headers().stream().map(policyStats.metrics()::get).map(this.metrics()::format).toArray(String[]::new);
        }
        return FlipTable.of((String[])this.headers().toArray(new String[0]), (String[][])data);
    }

    @Override
    protected Metrics newMetrics() {
        return Metrics.builder().percentFormatter(value -> String.format("%.2f %%", 100.0 * value)).doubleFormatter(value -> String.format("%.2f", value)).longFormatter(value -> String.format("%,d", value)).build();
    }
}

