/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser;

import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.adapt_size.AdaptSizeTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.address.AddressTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.address.penalties.AddressPenaltiesTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.arc.ArcTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.cache2k.Cache2kTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.camelab.CamelabTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.cloud_physics.CloudPhysicsTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.corda.CordaTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.gradle.GradleTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.kaggle.OutbrainTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.lirs.LirsTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.lrb.LrbTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.scarab.ScarabTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.snia.cambridge.CambridgeTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.snia.keyvalue.ObjectStoreTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.snia.parallel.K5cloudTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.snia.parallel.TencentBlockTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.snia.parallel.TencentPhotoTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.snia.systor.SystorTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.twitter.TwitterTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.umass.network.YoutubeTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.umass.storage.StorageTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.wikipedia.WikipediaTraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TraceFormat {
    ADDRESS(AddressTraceReader::new),
    ADDRESS_PENALTIES(AddressPenaltiesTraceReader::new),
    ADAPT_SIZE(AdaptSizeTraceReader::new),
    ARC(ArcTraceReader::new),
    CACHE2K(Cache2kTraceReader::new),
    CAMELAB(CamelabTraceReader::new),
    CLOUD_PHYSICS(CloudPhysicsTraceReader::new),
    CORDA(CordaTraceReader::new),
    GRADLE(GradleTraceReader::new),
    LIRS(LirsTraceReader::new),
    LRB(LrbTraceReader::new),
    OUTBRAIN(OutbrainTraceReader::new),
    SCARAB(ScarabTraceReader::new),
    SNIA_CAMBRIDGE(CambridgeTraceReader::new),
    SNIA_K5CLOUD(K5cloudTraceReader::new),
    SNIA_OBJECT_STORE(ObjectStoreTraceReader::new),
    SNIA_SYSTOR(SystorTraceReader::new),
    SNIA_TENCENT_BLOCK(TencentBlockTraceReader::new),
    SNIA_TENCENT_PHOTO(TencentPhotoTraceReader::new),
    TWITTER(TwitterTraceReader::new),
    UMASS_STORAGE(StorageTraceReader::new),
    UMASS_YOUTUBE(YoutubeTraceReader::new),
    WIKIPEDIA(WikipediaTraceReader::new);

    private final Function<String, TraceReader> factory;

    private TraceFormat(Function<String, TraceReader> factory) {
        this.factory = factory;
    }

    public TraceReader readFiles(final List<String> filePaths) {
        return new TraceReader(){

            @Override
            public Set<Policy.Characteristic> characteristics() {
                return (Set)this.readers().stream().flatMap(reader -> reader.characteristics().stream()).collect(Sets.toImmutableEnumSet());
            }

            @Override
            public Stream<AccessEvent> events() {
                return this.readers().stream().flatMap(TraceReader::events);
            }

            private List<TraceReader> readers() {
                return filePaths.stream().map(path -> {
                    List parts = Splitter.on((char)':').limit(2).splitToList((CharSequence)path);
                    TraceFormat format = parts.size() == 1 ? TraceFormat.this : TraceFormat.named((String)parts.get(0));
                    return format.factory.apply((String)Iterables.getLast((Iterable)parts));
                }).collect(Collectors.toList());
            }
        };
    }

    public static TraceFormat named(String name) {
        return TraceFormat.valueOf(name.replace('-', '_').toUpperCase(Locale.US));
    }
}

