/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.irr;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

@Policy.PolicySpec(name="irr.ClockPro")
public final class ClockProPolicy
implements Policy.KeyOnlyPolicy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private Node listHead;
    private Node handHot;
    private Node handCold;
    private Node handTest;
    private final int maxSize;
    private final int maxNonResSize;
    private int sizeHot;
    private int sizeResCold;
    private int sizeNonResCold;
    private int sizeInTest;
    private int sizeFree;
    private int coldTarget;
    private int minResColdSize;
    private int maxResColdSize;
    static final boolean debug = false;

    public ClockProPolicy(Config config) {
        ClockProSettings settings = new ClockProSettings(config);
        this.maxSize = Ints.checkedCast((long)settings.maximumSize());
        this.maxNonResSize = (int)((double)this.maxSize * settings.nonResidentMultiplier());
        this.minResColdSize = (int)((double)this.maxSize * settings.percentMinCold());
        if (this.minResColdSize < settings.lowerBoundCold()) {
            this.minResColdSize = settings.lowerBoundCold();
        }
        this.maxResColdSize = (int)((double)this.maxSize * settings.percentMaxCold());
        if (this.maxResColdSize > this.maxSize - this.minResColdSize) {
            this.maxResColdSize = this.maxSize - this.minResColdSize;
        }
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.data = new Long2ObjectOpenHashMap();
        this.coldTarget = this.minResColdSize;
        this.handTest = null;
        this.handCold = null;
        this.handHot = null;
        this.listHead = null;
        this.sizeFree = this.maxSize;
        Preconditions.checkState((this.minResColdSize <= this.maxResColdSize ? 1 : 0) != 0);
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        if (this.policyStats.requestCount() == 0L) {
            return;
        }
        this.validateStatus();
        this.validateClockStructure();
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node == null) {
            node = new Node(key);
            this.data.put(key, (Object)node);
            this.onMiss(node);
        } else if (node.isResident()) {
            this.onHit(node);
        } else {
            this.onMiss(node);
        }
    }

    private void onHit(Node node) {
        this.policyStats.recordHit();
        node.marked = true;
    }

    private void onMiss(Node node) {
        this.policyStats.recordMiss();
        if (this.sizeFree > this.minResColdSize) {
            this.onHotWarmupMiss(node);
        } else if (this.sizeFree > 0) {
            this.onColdWarmupMiss(node);
        } else {
            this.onFullMiss(node);
        }
        this.organizeHands();
    }

    private void onHotWarmupMiss(Node node) {
        node.moveToHead(Status.HOT);
    }

    private void onColdWarmupMiss(Node node) {
        node.moveToHead(Status.COLD_RES_IN_TEST);
    }

    private void onFullMiss(Node node) {
        if (node.status == Status.COLD_NON_RES) {
            this.onNonResidentFullMiss(node);
        } else if (node.status == Status.OUT_OF_CLOCK) {
            this.onOutOfClockFullMiss(node);
        } else {
            throw new IllegalStateException();
        }
    }

    private void onOutOfClockFullMiss(Node node) {
        this.evict();
        node.moveToHead(Status.COLD_RES_IN_TEST);
    }

    private void onNonResidentFullMiss(Node node) {
        this.evict();
        if (this.canPromote(node)) {
            node.moveToHead(Status.HOT);
        } else {
            node.moveToHead(Status.COLD_RES_IN_TEST);
        }
    }

    private void evict() {
        this.policyStats.recordEviction();
        while (this.sizeFree == 0) {
            this.runHandCold();
        }
    }

    private boolean canPromote(Node candidate) {
        if (!candidate.isInClock() || !candidate.isInTest()) {
            return false;
        }
        this.coldTargetAdjust(1);
        while (this.sizeHot >= this.maxSize - this.coldTarget) {
            if (!candidate.isInTest()) {
                return false;
            }
            if (this.runHandHot(candidate)) continue;
            return false;
        }
        return true;
    }

    private void runHandCold() {
        Preconditions.checkState((boolean)this.handCold.isResidentCold());
        if (this.handCold.marked) {
            if (this.handCold.isInTest()) {
                if (this.canPromote(this.handCold)) {
                    this.handCold.moveToHead(Status.HOT);
                } else {
                    this.handCold.moveToHead(Status.COLD_RES_IN_TEST);
                }
            } else {
                this.handCold.moveToHead(Status.COLD_RES_IN_TEST);
            }
        } else {
            if (this.handCold.isInTest()) {
                this.handCold.setStatus(Status.COLD_NON_RES);
                this.handCold = this.handCold.prev;
            } else {
                this.handCold.removeFromClock();
            }
            while (this.sizeNonResCold > this.maxNonResSize) {
                this.runHandTest();
            }
        }
        this.nextHandCold();
    }

    private boolean runHandHot(Node trigger) {
        Preconditions.checkState((boolean)this.handHot.isHot());
        Preconditions.checkState((boolean)trigger.isInTest());
        boolean demoted = false;
        while (this.handHot != trigger) {
            if (this.handHot.isHot()) {
                if (this.handHot.marked) {
                    this.handHot.moveToHead(Status.HOT);
                    continue;
                }
                this.handHot.moveToHead(Status.COLD_RES);
                demoted = true;
                break;
            }
            this.handHot = this.handHot.prev;
            this.terminateTestPeriod(this.handHot.next);
        }
        this.nextHandHot();
        return demoted;
    }

    private void runHandTest() {
        Preconditions.checkState((boolean)this.handTest.isInTest());
        this.terminateTestPeriod(this.handTest);
        this.nextHandTest();
    }

    private void terminateTestPeriod(Node node) {
        if (!node.isInTest()) {
            return;
        }
        if (node.isResidentCold()) {
            node.setStatus(Status.COLD_RES);
        } else {
            node.removeFromClock();
        }
        this.coldTargetAdjust(node.marked ? 1 : -1);
    }

    private void nextHandCold() {
        if (this.sizeResCold > 0) {
            if (this.handCold == null) {
                this.handCold = this.listHead.prev;
            }
            while (!this.handCold.isResidentCold()) {
                this.handCold = this.handCold.prev;
            }
        } else {
            this.handCold = null;
        }
    }

    private void nextHandHot() {
        if (this.sizeHot > 0) {
            if (this.handHot == null) {
                this.handHot = this.listHead.prev;
            }
            while (this.handHot.isCold()) {
                this.handHot = this.handHot.prev;
                this.terminateTestPeriod(this.handHot.next);
            }
            this.nextHandTest();
        } else {
            this.handHot = null;
        }
    }

    private void nextHandTest() {
        if (this.sizeInTest > 0) {
            if (this.handTest == null) {
                Node node = this.handTest = this.handHot == null ? this.listHead.prev : this.handHot;
            }
            while (!this.handTest.isInTest()) {
                this.handTest = this.handTest.prev;
            }
        } else {
            this.handTest = null;
        }
    }

    private void organizeHands() {
        this.nextHandCold();
        this.nextHandHot();
        this.nextHandTest();
    }

    private void coldTargetAdjust(int n) {
        this.coldTarget += n;
        if (this.coldTarget < this.minResColdSize) {
            this.coldTarget = this.minResColdSize;
        } else if (this.coldTarget > this.maxResColdSize) {
            this.coldTarget = this.maxResColdSize;
        }
    }

    private void validateClockStructure() {
        Node n;
        Preconditions.checkState((this.listHead != null ? 1 : 0) != 0);
        if (this.handHot == null) {
            Preconditions.checkState((this.sizeHot == 0 ? 1 : 0) != 0);
        } else {
            Preconditions.checkState((boolean)this.handHot.isHot());
            n = this.listHead.prev;
            while (n != this.handHot) {
                Preconditions.checkState((!n.isInTest() ? 1 : 0) != 0);
                Preconditions.checkState((n != this.handTest ? 1 : 0) != 0);
                n = n.prev;
            }
        }
        if (this.handCold == null) {
            Preconditions.checkState((this.sizeResCold == 0 ? 1 : 0) != 0);
        } else {
            Preconditions.checkState((boolean)this.handCold.isResidentCold());
            n = this.listHead.prev;
            while (n != this.handCold) {
                Preconditions.checkState((!n.isResidentCold() ? 1 : 0) != 0);
                n = n.prev;
            }
        }
        if (this.handTest == null) {
            Preconditions.checkState((this.sizeInTest == 0 ? 1 : 0) != 0);
        } else {
            Preconditions.checkState((boolean)this.handTest.isInTest());
            n = this.listHead.prev;
            while (n != this.handTest) {
                Preconditions.checkState((boolean)n.isResident());
                Preconditions.checkState((!n.isInTest() ? 1 : 0) != 0);
                n = n.prev;
            }
        }
    }

    private void validateStatus() {
        Preconditions.checkState((this.listHead != null ? 1 : 0) != 0);
        int sizeNonResCold = 0;
        int sizeResCold = 0;
        int sizeInTest = 0;
        int sizeHot = 0;
        Node node = this.listHead;
        while (node != null) {
            Preconditions.checkState((boolean)node.isInClock());
            if (node.isHot()) {
                ++sizeHot;
            }
            if (node.isResidentCold()) {
                ++sizeResCold;
            }
            if (!node.isResident()) {
                ++sizeNonResCold;
            }
            if (node.isInTest()) {
                ++sizeInTest;
            }
            if ((node = node.next) != this.listHead) continue;
        }
        Preconditions.checkState((sizeHot == this.sizeHot ? 1 : 0) != 0);
        Preconditions.checkState((sizeNonResCold == this.sizeNonResCold ? 1 : 0) != 0);
        Preconditions.checkState((sizeInTest == this.sizeInTest ? 1 : 0) != 0);
        Preconditions.checkState((sizeResCold == this.sizeResCold ? 1 : 0) != 0);
        Preconditions.checkState((sizeHot + sizeResCold == this.maxSize - this.sizeFree ? 1 : 0) != 0);
        Preconditions.checkState((sizeResCold + this.sizeFree >= this.minResColdSize ? 1 : 0) != 0);
        Preconditions.checkState((sizeResCold <= this.maxResColdSize ? 1 : 0) != 0);
        Preconditions.checkState((sizeNonResCold <= this.maxNonResSize ? 1 : 0) != 0);
    }

    private void printClock() {
        System.out.println("** CLOCK-Pro list HEAD (small recency) **");
        System.out.println(this.listHead.toString());
        Node n = this.listHead.next;
        while (n != this.listHead) {
            System.out.println(n.toString());
            n = n.next;
        }
        System.out.println("** CLOCK-Pro list TAIL (large recency) **");
    }

    static final class ClockProSettings
    extends BasicSettings {
        public ClockProSettings(Config config) {
            super(config);
        }

        public int lowerBoundCold() {
            return this.config().getInt("clockpro.lower-bound-resident-cold");
        }

        public double percentMinCold() {
            return this.config().getDouble("clockpro.percent-min-resident-cold");
        }

        public double percentMaxCold() {
            return this.config().getDouble("clockpro.percent-max-resident-cold");
        }

        public double nonResidentMultiplier() {
            return this.config().getDouble("clockpro.non-resident-multiplier");
        }
    }

    final class Node {
        final long key;
        Status status;
        Node prev;
        Node next;
        boolean marked;

        public Node(long key) {
            this.key = key;
            this.prev = this.next = this;
            this.status = Status.OUT_OF_CLOCK;
        }

        public void moveToHead(Status status) {
            if (this.isInClock()) {
                this.removeFromClock();
            }
            if (ClockProPolicy.this.listHead == null) {
                this.next = this.prev = this;
            } else {
                this.next = ClockProPolicy.this.listHead;
                this.prev = ClockProPolicy.this.listHead.prev;
                ClockProPolicy.this.listHead.prev.next = this;
                ClockProPolicy.this.listHead.prev = this;
            }
            this.setStatus(status);
            ClockProPolicy.this.listHead = this;
        }

        public void removeFromClock() {
            if (this == ClockProPolicy.this.listHead) {
                ClockProPolicy.this.listHead = ClockProPolicy.this.listHead.next;
            }
            if (this == ClockProPolicy.this.handCold) {
                ClockProPolicy.this.handCold = ClockProPolicy.this.handCold.prev;
            }
            if (this == ClockProPolicy.this.handHot) {
                ClockProPolicy.this.handHot = ClockProPolicy.this.handHot.prev;
            }
            if (this == ClockProPolicy.this.handTest) {
                ClockProPolicy.this.handTest = ClockProPolicy.this.handTest.prev;
            }
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = this.next = this;
            this.setStatus(Status.OUT_OF_CLOCK);
            this.marked = false;
        }

        public void setStatus(Status status) {
            if (this.isResident()) {
                ++ClockProPolicy.this.sizeFree;
            }
            if (this.isInTest()) {
                --ClockProPolicy.this.sizeInTest;
            }
            if (this.isResidentCold()) {
                --ClockProPolicy.this.sizeResCold;
            }
            if (this.status == Status.COLD_NON_RES) {
                --ClockProPolicy.this.sizeNonResCold;
            }
            if (this.status == Status.HOT) {
                --ClockProPolicy.this.sizeHot;
            }
            this.status = status;
            if (this.isResident()) {
                --ClockProPolicy.this.sizeFree;
            }
            if (this.isInTest()) {
                ++ClockProPolicy.this.sizeInTest;
            }
            if (this.isResidentCold()) {
                ++ClockProPolicy.this.sizeResCold;
            }
            if (this.status == Status.COLD_NON_RES) {
                ++ClockProPolicy.this.sizeNonResCold;
            }
            if (this.status == Status.HOT) {
                ++ClockProPolicy.this.sizeHot;
            }
        }

        boolean isInTest() {
            return this.status == Status.COLD_RES_IN_TEST || this.status == Status.COLD_NON_RES;
        }

        boolean isResident() {
            return this.isResidentCold() || this.status == Status.HOT;
        }

        boolean isResidentCold() {
            return this.status == Status.COLD_RES || this.status == Status.COLD_RES_IN_TEST;
        }

        boolean isCold() {
            return this.isResidentCold() || this.status == Status.COLD_NON_RES;
        }

        boolean isHot() {
            return this.status == Status.HOT;
        }

        boolean isInClock() {
            return this.status != Status.OUT_OF_CLOCK;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(MoreObjects.toStringHelper((Object)this).add("key", this.key).add("marked", this.marked).add("type", (Object)this.status).toString());
            if (this == ClockProPolicy.this.handHot) {
                sb.append(" <--[ HAND_HOT ]");
            }
            if (this == ClockProPolicy.this.handCold) {
                sb.append(" <--[ HAND_COLD ]");
            }
            if (this == ClockProPolicy.this.handTest) {
                sb.append(" <--[ HAND_TEST ]");
            }
            return sb.toString();
        }
    }

    static enum Status {
        HOT,
        COLD_RES,
        COLD_RES_IN_TEST,
        COLD_NON_RES,
        OUT_OF_CLOCK;

    }
}

