/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser;

import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.tukaani.xz.XZInputStream;

public abstract class AbstractTraceReader
implements TraceReader {
    private static final int BUFFER_SIZE = 65536;
    protected final String filePath;

    protected AbstractTraceReader(String filePath) {
        this.filePath = filePath.trim();
    }

    protected BufferedInputStream readFile() {
        try {
            return this.readInput(this.openFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected BufferedInputStream readInput(InputStream input) {
        BufferedInputStream buffered = null;
        try {
            buffered = new BufferedInputStream(input, 65536);
            ImmutableList extractors = ImmutableList.of(this::tryXZ, this::tryCompressed, this::tryArchived);
            for (Function extractor : extractors) {
                buffered.mark(100);
                InputStream next = (InputStream)extractor.apply(buffered);
                if (next == null) {
                    buffered.reset();
                    continue;
                }
                if (next instanceof BufferedInputStream) {
                    buffered = (BufferedInputStream)next;
                    continue;
                }
                buffered = new BufferedInputStream(next, 65536);
            }
            return buffered;
        }
        catch (Throwable t) {
            try {
                if (buffered != null) {
                    buffered.close();
                }
            }
            catch (IOException e) {
                t.addSuppressed(e);
            }
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    private @Nullable InputStream tryXZ(InputStream input) {
        try {
            return new XZInputStream(input);
        }
        catch (IOException e) {
            return null;
        }
    }

    private @Nullable InputStream tryCompressed(InputStream input) {
        try {
            return new CompressorStreamFactory().createCompressorInputStream(input);
        }
        catch (CompressorException e) {
            return null;
        }
    }

    private @Nullable InputStream tryArchived(InputStream input) {
        try {
            final ArchiveInputStream archive = new ArchiveStreamFactory().createArchiveInputStream(input);
            AbstractIterator<InputStream> entries = new AbstractIterator<InputStream>(){

                protected InputStream computeNext() {
                    try {
                        return archive.getNextEntry() == null ? (InputStream)this.endOfData() : AbstractTraceReader.this.readInput((InputStream)CloseShieldInputStream.wrap((InputStream)archive));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
            return new MultiInputStream((InputStream)archive, (Iterator<InputStream>)entries);
        }
        catch (ArchiveException e) {
            return null;
        }
    }

    private InputStream openFile() throws IOException {
        Path file = Paths.get(this.filePath, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            return Files.newInputStream(file, new OpenOption[0]);
        }
        InputStream input = this.getClass().getResourceAsStream(this.filePath);
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (String)"Could not find file: %s", (Object)this.filePath);
        return input;
    }

    private static final class MultiInputStream
    extends FilterInputStream {
        private final InputStream parent;

        public MultiInputStream(InputStream parent, Iterator<InputStream> children) {
            super(new SequenceInputStream(Iterators.asEnumeration(children)));
            this.parent = parent;
        }

        @Override
        public void close() throws IOException {
            this.parent.close();
        }
    }
}

