/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser;

import com.github.benmanes.caffeine.cache.simulator.parser.OutputFormat;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceFormat;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceWriter;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.google.common.base.Stopwatch;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import picocli.CommandLine;

public final class Rewriter
implements Runnable {
    @CommandLine.Option(names={"--inputFiles"}, required=true, split=",", description={"The trace input files. To use a mix of formats, specify the entry as format:path, e.g. lirs:loop.trace.gz"})
    private List<String> inputFiles;
    @CommandLine.Option(names={"--inputFormat"}, required=true, description={"The default trace input format"})
    private TraceFormat inputFormat;
    @CommandLine.Option(names={"--outputFile"}, required=true, description={"The trace output file"})
    private Path outputFile;
    @CommandLine.Option(names={"--outputFormat"}, required=true, description={"The trace output format"})
    private OutputFormat outputFormat;

    @Override
    public void run() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.outputFile, new OpenOption[0]));
             Stream<AccessEvent> events = this.inputFormat.readFiles(this.inputFiles).events();
             TraceWriter writer = this.outputFormat.writer(output);){
            int[] tick = new int[]{0};
            writer.writeHeader();
            events.forEach(event -> {
                try {
                    writer.writeEvent(tick[0], (AccessEvent)event);
                    tick[0] = tick[0] + 1;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            writer.writeFooter();
            System.out.printf("Rewrote %,d events from %,d inputs in %s%n", tick[0], this.inputFiles.size(), stopwatch);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void main(String[] args) {
        new CommandLine(Rewriter.class).setColorScheme(CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON)).setCommandName(Rewriter.class.getSimpleName()).setCaseInsensitiveEnumValuesAllowed(true).execute(args);
    }
}

