/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sampled;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admission;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class SampledPolicy
implements Policy.KeyOnlyPolicy {
    final Long2ObjectMap<Node> data;
    final PolicyStats policyStats;
    final EvictionPolicy policy;
    final Sample sampleStrategy;
    final Admittor admittor;
    final int maximumSize;
    final int sampleSize;
    final Random random;
    final Node[] table;
    long tick;

    public SampledPolicy(Admission admission, EvictionPolicy policy, Config config) {
        this.policyStats = new PolicyStats(admission.format("sampled." + policy.label()), new Object[0]);
        this.admittor = admission.from(config, this.policyStats);
        SampledSettings settings = new SampledSettings(config);
        this.maximumSize = Ints.checkedCast((long)settings.maximumSize());
        this.sampleStrategy = settings.sampleStrategy();
        this.random = new Random(settings.randomSeed());
        this.data = new Long2ObjectOpenHashMap();
        this.sampleSize = settings.sampleSize();
        this.table = new Node[this.maximumSize + 1];
        this.policy = policy;
    }

    public static Set<Policy> policies(Config config, EvictionPolicy policy) {
        BasicSettings settings = new BasicSettings(config);
        return settings.admission().stream().map(admission -> new SampledPolicy((Admission)((Object)admission), policy, config)).collect(Collectors.toSet());
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(long key) {
        Node node = (Node)this.data.get(key);
        this.admittor.record(key);
        long now = ++this.tick;
        if (node == null) {
            node = new Node(key, this.data.size(), now);
            this.policyStats.recordOperation();
            this.policyStats.recordMiss();
            this.table[node.index] = node;
            this.data.put(key, (Object)node);
            this.evict(node);
        } else {
            this.policyStats.recordOperation();
            this.policyStats.recordHit();
            node.accessTime = now;
            ++node.frequency;
        }
    }

    private void evict(Node candidate) {
        if (this.data.size() > this.maximumSize) {
            List<Node> sample = this.policy == EvictionPolicy.RANDOM ? Arrays.asList(this.table) : this.sampleStrategy.sample(this.table, candidate, this.sampleSize, this.random, this.policyStats);
            Node victim = this.policy.select(sample, this.random, this.tick);
            this.policyStats.recordEviction();
            if (this.admittor.admit(candidate.key, victim.key)) {
                this.removeFromTable(victim);
                this.data.remove(victim.key);
            } else {
                this.removeFromTable(candidate);
                this.data.remove(candidate.key);
            }
        }
    }

    private void removeFromTable(Node node) {
        int last = this.data.size() - 1;
        this.table[node.index] = this.table[last];
        this.table[node.index].index = node.index;
        this.table[last] = null;
    }

    static final class SampledSettings
    extends BasicSettings {
        public SampledSettings(Config config) {
            super(config);
        }

        public int sampleSize() {
            return this.config().getInt("sampled.size");
        }

        public Sample sampleStrategy() {
            return Sample.valueOf(this.config().getString("sampled.strategy").toUpperCase(Locale.US));
        }
    }

    static final class Node {
        final long key;
        final long insertionTime;
        long accessTime;
        int frequency;
        int index;

        public Node(long key, int index, long tick) {
            this.insertionTime = tick;
            this.accessTime = tick;
            this.index = index;
            this.key = key;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("index", this.index).toString();
        }
    }

    public static enum EvictionPolicy {
        FIFO{

            @Override
            Node select(List<Node> sample, Random random, long tick) {
                return sample.stream().min(Comparator.comparingLong(node -> node.insertionTime)).get();
            }
        }
        ,
        LRU{

            @Override
            Node select(List<Node> sample, Random random, long tick) {
                return sample.stream().min(Comparator.comparingLong(node -> node.accessTime)).get();
            }
        }
        ,
        MRU{

            @Override
            Node select(List<Node> sample, Random random, long tick) {
                return sample.stream().max(Comparator.comparingLong(node -> node.accessTime)).get();
            }
        }
        ,
        LFU{

            @Override
            Node select(List<Node> sample, Random random, long tick) {
                return sample.stream().min(Comparator.comparingLong(node -> node.frequency)).get();
            }
        }
        ,
        MFU{

            @Override
            Node select(List<Node> sample, Random random, long tick) {
                return sample.stream().max(Comparator.comparingLong(node -> node.frequency)).get();
            }
        }
        ,
        RANDOM{

            @Override
            Node select(List<Node> sample, Random random, long tick) {
                int victim = random.nextInt(sample.size());
                return sample.get(victim);
            }
        }
        ,
        HYPERBOLIC{

            @Override
            Node select(List<Node> sample, Random random, long tick) {
                return sample.stream().min(Comparator.comparingDouble(node -> this.hyperbolic((Node)node, tick))).get();
            }

            double hyperbolic(Node node, long tick) {
                return (double)node.frequency / (double)(tick - node.insertionTime);
            }
        };


        public String label() {
            return "sampled." + StringUtils.capitalize((String)this.name().toLowerCase(Locale.US));
        }

        abstract Node select(List<Node> var1, Random var2, long var3);
    }

    public static enum Sample {
        GUESS{

            @Override
            public <E> List<E> sample(E[] elements, E candidate, int sampleSize, Random random, PolicyStats policyStats) {
                ArrayList<E> sample = new ArrayList<E>(sampleSize);
                policyStats.addOperations(sampleSize);
                while (sample.size() < sampleSize) {
                    int index = random.nextInt(elements.length);
                    if (elements[index] == candidate) continue;
                    sample.add(elements[index]);
                }
                return sample;
            }
        }
        ,
        RESERVOIR{

            @Override
            public <E> List<E> sample(E[] elements, E candidate, int sampleSize, Random random, PolicyStats policyStats) {
                ArrayList<E> sample = new ArrayList<E>(sampleSize);
                policyStats.addOperations(elements.length);
                int count = 0;
                for (E e : elements) {
                    if (e == candidate) continue;
                    ++count;
                    if (sample.size() <= sampleSize) {
                        sample.add(e);
                        continue;
                    }
                    int index = random.nextInt(count);
                    if (index >= sampleSize) continue;
                    sample.set(index, e);
                }
                return sample;
            }
        }
        ,
        SHUFFLE{

            @Override
            public <E> List<E> sample(E[] elements, E candidate, int sampleSize, Random random, PolicyStats policyStats) {
                ArrayList<E> sample = new ArrayList<E>(Arrays.asList(elements));
                policyStats.addOperations(elements.length);
                Collections.shuffle(sample, random);
                sample.remove(candidate);
                return sample.subList(0, sampleSize);
            }
        };


        abstract <E> List<E> sample(E[] var1, E var2, int var3, Random var4, PolicyStats var5);
    }
}

