/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.snia.keyvalue;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.google.common.primitives.Ints;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public final class ObjectStoreTraceReader
extends TextTraceReader {
    public ObjectStoreTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public Set<Policy.Characteristic> characteristics() {
        return Set.of(Policy.Characteristic.WEIGHTED);
    }

    @Override
    public Stream<AccessEvent> events() {
        return this.lines().map(line -> line.split(" ")).filter(array -> array[1].equals("REST.GET.OBJECT")).map(array -> {
            long start = Long.parseLong(array[4]);
            long end = Long.parseLong(array[5]);
            int weight = Ints.saturatedCast((long)(end - start));
            if (weight <= 0) {
                return null;
            }
            long key = new BigInteger(array[2], 16).longValue();
            return AccessEvent.forKeyAndWeight(key, weight);
        }).filter(Objects::nonNull);
    }
}

