/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import com.github.benmanes.caffeine.cache.simulator.policy.AutoValue_PolicyStats_Metric;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.google.auto.value.AutoValue;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class PolicyStats {
    private final Map<String, Metric> metrics;
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private final String name;
    private long hitCount;
    private long missCount;
    private long hitsWeight;
    private long missesWeight;
    private double hitPenalty;
    private double missPenalty;
    private long evictionCount;
    private long admittedCount;
    private long rejectedCount;
    private long operationCount;
    private double percentAdaption;

    public PolicyStats(String format, Object ... args) {
        this.name = String.format(Locale.US, format, args);
        this.metrics = new LinkedHashMap<String, Metric>();
        this.addMetric(Metric.of("Policy", this::name, Metric.MetricType.OBJECT, true));
        this.addMetric(Metric.of("Hit Rate", this::hitRate, Metric.MetricType.PERCENT, true));
        this.addMetric(Metric.of("Hits", this::hitCount, Metric.MetricType.NUMBER, true));
        this.addMetric(Metric.of("Misses", this::missCount, Metric.MetricType.NUMBER, true));
        this.addMetric(Metric.of("Requests", this::requestCount, Metric.MetricType.NUMBER, true));
        this.addMetric(Metric.of("Evictions", this::evictionCount, Metric.MetricType.NUMBER, true));
        this.addPercentMetric("Admit rate", () -> this.admittedCount + this.rejectedCount == 0L ? 0.0 : this.admissionRate());
        this.addMetric(Metric.builder().value(this::requestsWeight).addCharacteristic(Policy.Characteristic.WEIGHTED).name("Requests Weight").type(Metric.MetricType.NUMBER).build());
        this.addMetric(Metric.builder().value(this::weightedHitRate).addCharacteristic(Policy.Characteristic.WEIGHTED).name("Weighted Hit Rate").type(Metric.MetricType.PERCENT).build());
        this.addPercentMetric("Adaption", this::percentAdaption);
        this.addMetric("Average Miss Penalty", this::averageMissPenalty);
        this.addMetric("Average Penalty", this::avergePenalty);
        this.addMetric("Steps", this::operationCount);
        this.addMetric("Time", this::stopwatch);
    }

    public void addMetric(Metric metric) {
        this.metrics.put(metric.name(), Objects.requireNonNull(metric));
    }

    public void addMetric(String name, Supplier<?> supplier) {
        this.addMetric(Metric.builder().name(name).value(supplier).type(Metric.MetricType.OBJECT).build());
    }

    public void addMetric(String name, LongSupplier supplier) {
        this.addMetric(Metric.builder().name(name).value(supplier).type(Metric.MetricType.NUMBER).build());
    }

    public void addMetric(String name, DoubleSupplier supplier) {
        this.addMetric(Metric.builder().name(name).value(supplier).type(Metric.MetricType.NUMBER).build());
    }

    public void addPercentMetric(String name, DoubleSupplier supplier) {
        this.addMetric(Metric.builder().name(name).value(supplier).type(Metric.MetricType.PERCENT).build());
    }

    public Map<String, Metric> metrics() {
        return this.metrics;
    }

    public Stopwatch stopwatch() {
        return this.stopwatch;
    }

    public String name() {
        return this.name;
    }

    public void recordOperation() {
        ++this.operationCount;
    }

    public long operationCount() {
        return this.operationCount;
    }

    public void addOperations(long operations) {
        this.operationCount += operations;
    }

    public void recordHit() {
        ++this.hitCount;
    }

    public long hitCount() {
        return this.hitCount;
    }

    public void addHits(long hits) {
        this.hitCount += hits;
    }

    public void recordWeightedHit(int weight) {
        this.hitsWeight += (long)weight;
        this.recordHit();
    }

    public long hitsWeight() {
        return this.hitsWeight;
    }

    public void recordHitPenalty(double penalty) {
        this.hitPenalty += penalty;
    }

    public double hitPenalty() {
        return this.hitPenalty;
    }

    public void recordMiss() {
        ++this.missCount;
    }

    public long missCount() {
        return this.missCount;
    }

    public void addMisses(long misses) {
        this.missCount += misses;
    }

    public void recordWeightedMiss(int weight) {
        this.missesWeight += (long)weight;
        this.recordMiss();
    }

    public long missesWeight() {
        return this.missesWeight;
    }

    public void recordMissPenalty(double penalty) {
        this.missPenalty += penalty;
    }

    public double missPenalty() {
        return this.missPenalty;
    }

    public long evictionCount() {
        return this.evictionCount;
    }

    public void recordEviction() {
        ++this.evictionCount;
    }

    public void addEvictions(long evictions) {
        this.evictionCount += evictions;
    }

    public long requestCount() {
        return this.hitCount + this.missCount;
    }

    public long requestsWeight() {
        return this.hitsWeight + this.missesWeight;
    }

    public long admissionCount() {
        return this.admittedCount;
    }

    public void recordAdmission() {
        ++this.admittedCount;
    }

    public long rejectionCount() {
        return this.rejectedCount;
    }

    public void recordRejection() {
        ++this.rejectedCount;
    }

    public double totalPenalty() {
        return this.hitPenalty + this.missPenalty;
    }

    public double percentAdaption() {
        return this.percentAdaption;
    }

    public void setPercentAdaption(double percentAdaption) {
        this.percentAdaption = Math.floor(100.0 * percentAdaption) / 100.0;
    }

    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    public double weightedHitRate() {
        long requestsWeight = this.requestsWeight();
        return requestsWeight == 0L ? 1.0 : (double)this.hitsWeight / (double)requestsWeight;
    }

    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    public double weightedMissRate() {
        long requestsWeight = this.requestsWeight();
        return requestsWeight == 0L ? 1.0 : (double)this.missesWeight / (double)requestsWeight;
    }

    public double admissionRate() {
        long candidateCount = this.admittedCount + this.rejectedCount;
        return candidateCount == 0L ? 1.0 : (double)this.admittedCount / (double)candidateCount;
    }

    public double complexity() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.operationCount / (double)requestCount;
    }

    public double avergePenalty() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : this.totalPenalty() / (double)requestCount;
    }

    public double avergeHitPenalty() {
        return this.hitCount == 0L ? 0.0 : this.hitPenalty / (double)this.hitCount;
    }

    public double averageMissPenalty() {
        return this.missCount == 0L ? 0.0 : this.missPenalty / (double)this.missCount;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    @AutoValue
    public static abstract class Metric {
        public abstract String name();

        public abstract Object value();

        public abstract MetricType type();

        public abstract boolean required();

        public abstract ImmutableSet<Policy.Characteristic> characteristics();

        public static Metric of(String name, Object value, MetricType type, boolean required) {
            return Metric.builder().name(name).value(value).type(type).required(required).build();
        }

        public static Builder builder() {
            return new AutoValue_PolicyStats_Metric.Builder().required(false);
        }

        @AutoValue.Builder
        @AutoValue.CopyAnnotations
        public static abstract class Builder {
            public abstract Builder name(String var1);

            public abstract Builder value(Object var1);

            public abstract Builder type(MetricType var1);

            public abstract Builder required(boolean var1);

            public abstract ImmutableSet.Builder<Policy.Characteristic> characteristicsBuilder();

            public abstract Metric build();

            @CanIgnoreReturnValue
            public final Builder addCharacteristic(Policy.Characteristic characteristic) {
                this.characteristicsBuilder().add((Object)characteristic);
                return this;
            }
        }

        public static enum MetricType {
            NUMBER,
            PERCENT,
            OBJECT;

        }
    }
}

