/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.tinycache;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Frequency;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinyCacheSketch;
import com.typesafe.config.Config;

public final class TinyCacheAdapter
implements Frequency {
    static final int sampleFactor = 10;
    static final int maxcount = 10;
    final TinyCacheSketch tcs;

    public TinyCacheAdapter(Config config) {
        BasicSettings settings = new BasicSettings(config);
        int nrSets = Math.toIntExact(10L * settings.maximumSize() / 64L);
        this.tcs = new TinyCacheSketch(nrSets, 64, settings.randomSeed());
    }

    @Override
    public int frequency(long e) {
        return this.tcs.countItem(e);
    }

    @Override
    public void increment(long e) {
        if (this.tcs.countItem(e) < 10) {
            this.tcs.addItem(e);
        }
    }
}

