/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.tracing;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.ThreadLocalRandom;

public final class TracerIdGenerator {
    private static final long EPOCH = 1288834974657L;
    private static final int TIMESTAMP_SHIFT = 13;
    private static final int MAX_MACHINE_ID = 1024;
    private static final int MACHINE_ID_SHIFT = 54;
    private static final long MACHINE_ID = TracerIdGenerator.getMachineId();
    private static final int MAX_SEQUENCE_MASK = 4095;
    private long lastTimestamp;
    private int sequence;

    public synchronized long nextId() {
        this.initializeSeeds();
        return this.lastTimestamp - 1288834974657L << 13 | MACHINE_ID << 54 | (long)this.sequence;
    }

    private void initializeSeeds() {
        long timestamp = Math.max(this.lastTimestamp, System.currentTimeMillis());
        if (timestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1 & 0xFFF;
            if (this.sequence == 0) {
                ++timestamp;
            }
        } else {
            this.sequence = 0;
        }
        this.lastTimestamp = timestamp;
    }

    private static long getMachineId() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            byte[] mac = NetworkInterface.getByInetAddress(ip).getHardwareAddress();
            return (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
        }
        catch (SocketException | UnknownHostException e) {
            return ThreadLocalRandom.current().nextLong(1024L);
        }
    }
}

