/*
 * Decompiled with CFR 0.152.
 */
package com.github.benfradet.spark.kafka.writer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.KafkaProducer;
import scala.Function1;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering;

public final class KafkaProducerCache$ {
    public static final KafkaProducerCache$ MODULE$ = new KafkaProducerCache$();
    private static final RemovalListener<Seq<Tuple2<String, Object>>, KafkaProducer<?, ?>> removalListener = new RemovalListener<Seq<Tuple2<String, Object>>, KafkaProducer<?, ?>>(){

        public void onRemoval(RemovalNotification<Seq<Tuple2<String, Object>>, KafkaProducer<?, ?>> notif) {
            ((KafkaProducer)notif.getValue()).close();
        }
    };
    private static final long cacheExpireTimeout = new package.DurationInt(package$.MODULE$.DurationInt(10)).minutes().toMillis();
    private static final Cache<Seq<Tuple2<String, Object>>, KafkaProducer<?, ?>> cache = CacheBuilder.newBuilder().expireAfterAccess(MODULE$.cacheExpireTimeout(), TimeUnit.MILLISECONDS).removalListener(MODULE$.removalListener()).build();

    private RemovalListener<Seq<Tuple2<String, Object>>, KafkaProducer<?, ?>> removalListener() {
        return removalListener;
    }

    private long cacheExpireTimeout() {
        return cacheExpireTimeout;
    }

    private Cache<Seq<Tuple2<String, Object>>, KafkaProducer<?, ?>> cache() {
        return cache;
    }

    public <K, V> KafkaProducer<K, V> getProducer(scala.collection.immutable.Map<String, Object> producerConfig) {
        KafkaProducer kafkaProducer;
        try {
            kafkaProducer = (KafkaProducer)this.cache().get(this.mapToSeq(producerConfig), new Callable<KafkaProducer<K, V>>(producerConfig){
                private final scala.collection.immutable.Map producerConfig$1;

                public KafkaProducer<K, V> call() {
                    return new KafkaProducer((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.producerConfig$1).asJava());
                }
                {
                    this.producerConfig$1 = producerConfig$1;
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ExecutionException ? true : (throwable2 instanceof UncheckedExecutionException ? true : throwable2 instanceof ExecutionError);
            if (bl && throwable2.getCause() != null) {
                throw throwable2.getCause();
            }
            throw throwable;
        }
        return kafkaProducer;
    }

    public void close(scala.collection.immutable.Map<String, Object> producerConfig) {
        this.cache().invalidate(this.mapToSeq(producerConfig));
    }

    private Seq<Tuple2<String, Object>> mapToSeq(scala.collection.immutable.Map<String, Object> m) {
        return (Seq)m.toSeq().sortBy((Function1 & Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$);
    }

    private KafkaProducerCache$() {
    }
}

