/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.DocWriter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.io.IOException;
import java.io.OutputStream;

public class RtfPageSetting
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] PAGE_WIDTH = DocWriter.getISOBytes((String)"\\paperw");
    private static final byte[] PAGE_HEIGHT = DocWriter.getISOBytes((String)"\\paperh");
    private static final byte[] MARGIN_LEFT = DocWriter.getISOBytes((String)"\\margl");
    private static final byte[] MARGIN_RIGHT = DocWriter.getISOBytes((String)"\\margr");
    private static final byte[] MARGIN_TOP = DocWriter.getISOBytes((String)"\\margt");
    private static final byte[] MARGIN_BOTTOM = DocWriter.getISOBytes((String)"\\margb");
    private static final byte[] LANDSCAPE = DocWriter.getISOBytes((String)"\\lndscpsxn");
    private static final byte[] SECTION_PAGE_WIDTH = DocWriter.getISOBytes((String)"\\pgwsxn");
    private static final byte[] SECTION_PAGE_HEIGHT = DocWriter.getISOBytes((String)"\\pghsxn");
    private static final byte[] SECTION_MARGIN_LEFT = DocWriter.getISOBytes((String)"\\marglsxn");
    private static final byte[] SECTION_MARGIN_RIGHT = DocWriter.getISOBytes((String)"\\margrsxn");
    private static final byte[] SECTION_MARGIN_TOP = DocWriter.getISOBytes((String)"\\margtsxn");
    private static final byte[] SECTION_MARGIN_BOTTOM = DocWriter.getISOBytes((String)"\\margbsxn");
    private int pageWidth = 11906;
    private int pageHeight = 16840;
    private int marginLeft = 1800;
    private int marginRight = 1800;
    private int marginTop = 1440;
    private int marginBottom = 1440;
    private boolean landscape = false;

    public RtfPageSetting(RtfDocument doc) {
        super(doc);
    }

    @Override
    public void writeContent(OutputStream out) throws IOException {
    }

    @Override
    public void writeDefinition(OutputStream result) throws IOException {
        result.write(PAGE_WIDTH);
        result.write(this.intToByteArray(this.pageWidth));
        result.write(PAGE_HEIGHT);
        result.write(this.intToByteArray(this.pageHeight));
        result.write(MARGIN_LEFT);
        result.write(this.intToByteArray(this.marginLeft));
        result.write(MARGIN_RIGHT);
        result.write(this.intToByteArray(this.marginRight));
        result.write(MARGIN_TOP);
        result.write(this.intToByteArray(this.marginTop));
        result.write(MARGIN_BOTTOM);
        result.write(this.intToByteArray(this.marginBottom));
        this.document.outputDebugLinebreak(result);
    }

    public void writeSectionDefinition(OutputStream result) throws IOException {
        if (this.landscape) {
            result.write(LANDSCAPE);
            result.write(SECTION_PAGE_WIDTH);
            result.write(this.intToByteArray(this.pageWidth));
            result.write(SECTION_PAGE_HEIGHT);
            result.write(this.intToByteArray(this.pageHeight));
            this.document.outputDebugLinebreak(result);
        } else {
            result.write(SECTION_PAGE_WIDTH);
            result.write(this.intToByteArray(this.pageWidth));
            result.write(SECTION_PAGE_HEIGHT);
            result.write(this.intToByteArray(this.pageHeight));
            this.document.outputDebugLinebreak(result);
        }
        result.write(SECTION_MARGIN_LEFT);
        result.write(this.intToByteArray(this.marginLeft));
        result.write(SECTION_MARGIN_RIGHT);
        result.write(this.intToByteArray(this.marginRight));
        result.write(SECTION_MARGIN_TOP);
        result.write(this.intToByteArray(this.marginTop));
        result.write(SECTION_MARGIN_BOTTOM);
        result.write(this.intToByteArray(this.marginBottom));
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
    }

    public void setPageSize(Rectangle pageSize) {
        if (!this.guessFormat(pageSize, false)) {
            this.pageWidth = (int)((double)pageSize.getWidth() * 20.0);
            this.pageHeight = (int)((double)pageSize.getHeight() * 20.0);
            this.landscape = this.pageWidth > this.pageHeight;
        }
    }

    private boolean guessFormat(Rectangle pageSize, boolean rotate) {
        if (rotate) {
            pageSize = pageSize.rotate();
        }
        if (this.rectEquals(pageSize, PageSize.A3)) {
            this.pageWidth = 16837;
            this.pageHeight = 23811;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.A4)) {
            this.pageWidth = 11907;
            this.pageHeight = 16840;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.A5)) {
            this.pageWidth = 8391;
            this.pageHeight = 11907;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.A6)) {
            this.pageWidth = 5959;
            this.pageHeight = 8420;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.B4)) {
            this.pageWidth = 14570;
            this.pageHeight = 20636;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.B5)) {
            this.pageWidth = 10319;
            this.pageHeight = 14572;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.HALFLETTER)) {
            this.pageWidth = 7927;
            this.pageHeight = 12247;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.LETTER)) {
            this.pageWidth = 12242;
            this.pageHeight = 15842;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.LEGAL)) {
            this.pageWidth = 12252;
            this.pageHeight = 20163;
            this.landscape = rotate;
            return true;
        }
        if (!rotate && this.guessFormat(pageSize, true)) {
            int x = this.pageWidth;
            this.pageWidth = this.pageHeight;
            this.pageHeight = x;
            return true;
        }
        return false;
    }

    private boolean rectEquals(Rectangle rect1, Rectangle rect2) {
        return rect1.getWidth() == rect2.getWidth() && rect1.getHeight() == rect2.getHeight();
    }
}

