/*
 * Decompiled with CFR 0.152.
 */
package profilers;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.FileUtils;

public class FlightRecordingProfiler
implements ExternalProfiler {
    private String startFlightRecordingOptions = "duration=60s,name=profile,settings=profile,";
    private String flightRecorderOptions = "samplethreads=true,";
    private static final String SAVE_FLIGHT_OUTPUT_TO = System.getProperty("jmh.jfr.saveTo", ".");
    private final String jfrData = FileUtils.tempFile((String)"jfrData").getAbsolutePath();
    private static final boolean IS_SUPPORTED = ManagementFactory.getRuntimeMXBean().getInputArguments().contains("-XX:+UnlockCommercialFeatures");
    static int currentId;

    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    public Collection<String> addJVMOptions(BenchmarkParams params) {
        this.startFlightRecordingOptions = this.startFlightRecordingOptions + "filename=" + this.jfrData;
        String jfcPath = Paths.get(params.getJvm(), new String[0]).resolve("../../lib/jfr/profile.jfc").normalize().toAbsolutePath().toString();
        this.flightRecorderOptions = this.flightRecorderOptions + ",settings=" + jfcPath;
        return Arrays.asList("-XX:+FlightRecorder", "-XX:StartFlightRecording=" + this.startFlightRecordingOptions, "-XX:FlightRecorderOptions=" + this.flightRecorderOptions);
    }

    public void beforeTrial(BenchmarkParams benchmarkParams) {
    }

    public Collection<? extends Result> afterTrial(BenchmarkResult benchmarkResult, long l, File stdOut, File stdErr) {
        String target = Paths.get(SAVE_FLIGHT_OUTPUT_TO, new String[0]).resolve(benchmarkResult.getParams().getBenchmark() + "-" + currentId++ + ".jfr").toAbsolutePath().toString();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            FileUtils.copy((String)this.jfrData, (String)target);
            pw.println("Flight Recording output saved to " + target);
        }
        catch (IOException e) {
            e.printStackTrace();
            pw.println("Unable to save flight output to " + target);
            pw.println("Did you miss the system property: -Djmh.jfr.saveTo ?");
        }
        pw.flush();
        pw.close();
        NoResult r = new NoResult(sw.toString());
        return Collections.singleton(r);
    }

    public boolean allowPrintOut() {
        return true;
    }

    public boolean allowPrintErr() {
        return false;
    }

    public boolean checkSupport(List<String> msgs) {
        msgs.add("Commercial features of the JVM need to be enabled for this profiler.");
        return IS_SUPPORTED;
    }

    public String label() {
        return "jfr";
    }

    public String getDescription() {
        return "Java Flight Recording profiler runs for every benchmark.";
    }

    private class NoResult
    extends Result<NoResult> {
        private final String output;

        public NoResult(String output) {
            super(ResultRole.SECONDARY, "JFR", NoResult.of((double)Double.NaN), "N/A", AggregationPolicy.SUM);
            this.output = output;
        }

        protected Aggregator<NoResult> getThreadAggregator() {
            return new NoResultAggregator();
        }

        protected Aggregator<NoResult> getIterationAggregator() {
            return new NoResultAggregator();
        }

        public String extendedInfo() {
            return "JFR Messages:\n--------------------------------------------\n" + this.output;
        }

        private class NoResultAggregator
        implements Aggregator<NoResult> {
            private NoResultAggregator() {
            }

            public NoResult aggregate(Collection<NoResult> results) {
                String output = "";
                for (NoResult r : results) {
                    output = output + r.output;
                }
                return new NoResult(output);
            }
        }
    }
}

