/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.events.handlers;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import no.unit.nva.events.EventsConfig;
import no.unit.nva.events.handlers.EventParser;
import no.unit.nva.events.models.AwsEventBridgeEvent;
import nva.commons.core.exceptions.ExceptionUtils;
import nva.commons.core.ioutils.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventHandler<InputType, OutputType>
implements RequestStreamHandler {
    public static final String HANDLER_INPUT = "Handler input:\n";
    public static final String ERROR_WRITING_TO_OUTPUT_STREAM = "Error writing output to output stream. Output is: ";
    private static final Logger logger = LoggerFactory.getLogger(EventHandler.class);
    protected final ObjectMapper objectMapper;
    private final Class<InputType> iclass;

    protected EventHandler(Class iclass, ObjectMapper objectMapper) {
        this.iclass = iclass;
        this.objectMapper = objectMapper;
    }

    protected EventHandler(Class iclass) {
        this(iclass, EventsConfig.objectMapper);
    }

    public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) {
        String inputString = null;
        try {
            inputString = IoUtils.streamToString((InputStream)inputStream);
            logger.trace(HANDLER_INPUT + inputString);
            AwsEventBridgeEvent<InputType> input = this.parseEvent(inputString);
            OutputType output = this.processInput(input.getDetail(), input, context);
            this.writeOutput(outputStream, output);
        }
        catch (Exception e) {
            this.handleError(e, inputString);
            throw e;
        }
    }

    protected void writeOutput(OutputStream outputStream, OutputType output) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            String responseJson = this.objectMapper.writeValueAsString(output);
            writer.write(responseJson);
        }
        catch (IOException e) {
            logger.error(ERROR_WRITING_TO_OUTPUT_STREAM + output.toString());
            throw new UncheckedIOException(e);
        }
    }

    protected abstract OutputType processInput(InputType var1, AwsEventBridgeEvent<InputType> var2, Context var3);

    protected AwsEventBridgeEvent<InputType> parseEvent(String input) {
        return new EventParser<InputType>(input, this.objectMapper).parse(this.iclass);
    }

    protected void handleError(Exception e, String inputString) {
        logger.error(ExceptionUtils.stackTraceInSingleLine((Exception)e));
    }
}

