/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.events.handlers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import no.unit.nva.events.models.AwsEventBridgeEvent;
import nva.commons.core.attempt.Failure;
import nva.commons.core.attempt.Try;
import nva.commons.core.exceptions.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventParser<InputType> {
    public static final String ERROR_PARSING_INPUT = "Could not parse input: ";
    public static final int SKIP_BOTTOM_TYPE = 2;
    public static final String RAWTYPES = "rawtypes";
    private static final Logger logger = LoggerFactory.getLogger(EventParser.class);
    private final String input;
    private final ObjectMapper objectMapper;

    public EventParser(String input, ObjectMapper objectMapper) {
        this.input = input;
        this.objectMapper = objectMapper;
    }

    public AwsEventBridgeEvent<InputType> parse(Class<InputType> iclass) {
        return (AwsEventBridgeEvent)Try.attempt(() -> this.parseJson(iclass)).orElseThrow(this::handleParsingError);
    }

    public AwsEventBridgeEvent parse(Class ... nestedParameterClasses) {
        return (AwsEventBridgeEvent)Try.attempt(() -> this.parseJson(nestedParameterClasses)).orElseThrow(this::handleParsingError);
    }

    private AwsEventBridgeEvent<InputType> parseJson(Class<InputType> iclass) throws JsonProcessingException {
        JavaType javaType = this.objectMapper.getTypeFactory().constructParametricType(AwsEventBridgeEvent.class, new Class[]{iclass});
        return (AwsEventBridgeEvent)this.objectMapper.readValue(this.input, javaType);
    }

    private AwsEventBridgeEvent<?> parseJson(Class<?> ... nestedClasses) throws JsonProcessingException {
        JavaType nestedJavaTypes = this.nestedGenericTypesToJavaType(nestedClasses);
        JavaType eventBridgeJavaType = this.constructAwsEventBridgeDataTypeWithAllNestedTypes(nestedJavaTypes);
        return (AwsEventBridgeEvent)this.objectMapper.readValue(this.input, eventBridgeJavaType);
    }

    private <OutputType> RuntimeException handleParsingError(Failure<OutputType> fail) {
        logger.error(ERROR_PARSING_INPUT + this.input);
        logger.error(ExceptionUtils.stackTraceInSingleLine((Exception)fail.getException()));
        return new RuntimeException(fail.getException());
    }

    private JavaType nestedGenericTypesToJavaType(Class[] classes) {
        JavaType mostRecentType = this.objectMapper.getTypeFactory().constructType((Type)this.innermostType(classes));
        for (int index = classes.length - 2; index >= 0; --index) {
            Class currentClass = classes[index];
            mostRecentType = this.createGenericClassContainingAllPreviousTypes(mostRecentType, currentClass);
        }
        return mostRecentType;
    }

    private JavaType createGenericClassContainingAllPreviousTypes(JavaType mostRecentType, Class<?> currentClass) {
        return this.objectMapper.getTypeFactory().constructParametricType(currentClass, new JavaType[]{mostRecentType});
    }

    private <T> T innermostType(T[] classes) {
        return classes[classes.length - 1];
    }

    private JavaType constructAwsEventBridgeDataTypeWithAllNestedTypes(JavaType mostRecentType) {
        return this.objectMapper.getTypeFactory().constructParametricType(AwsEventBridgeEvent.class, new JavaType[]{mostRecentType});
    }
}

