/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.events.models;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import no.unit.nva.commons.json.JsonSerializable;
import no.unit.nva.events.EventsConfig;
import no.unit.nva.events.models.EventBody;
import nva.commons.core.JacocoGenerated;
import software.amazon.awssdk.services.eventbridge.model.PutEventsRequestEntry;

public class ScanDatabaseRequest
implements EventBody,
JsonSerializable {
    public static final String START_MARKER = "startMarker";
    public static final String PAGE_SIZE = "pageSize";
    public static final int DEFAULT_PAGE_SIZE = 700;
    public static final int MAX_PAGE_SIZE = 1000;
    @JsonProperty(value="startMarker")
    private final Map<String, AttributeValue> startMarker;
    @JsonProperty(value="pageSize")
    private final int pageSize;
    @JsonProperty(value="topic")
    private final String topic;

    @JsonCreator
    public ScanDatabaseRequest(@JsonProperty(value="topic") String topic, @JsonProperty(value="pageSize") Integer pageSize, @JsonProperty(value="startMarker") Map<String, AttributeValue> startMarker) {
        this.pageSize = Optional.ofNullable(pageSize).orElse(700);
        this.startMarker = startMarker;
        this.topic = topic;
    }

    public static ScanDatabaseRequest fromJson(String detail) throws JsonProcessingException {
        return (ScanDatabaseRequest)EventsConfig.objectMapper.readValue(detail, ScanDatabaseRequest.class);
    }

    @Override
    @JacocoGenerated
    public String getTopic() {
        return this.topic;
    }

    public int getPageSize() {
        return this.pageSizeWithinLimits(this.pageSize) ? this.pageSize : 700;
    }

    @JacocoGenerated
    public Map<String, AttributeValue> getStartMarker() {
        return this.startMarker;
    }

    public ScanDatabaseRequest newScanDatabaseRequest(Map<String, AttributeValue> newStartMarker) {
        return new ScanDatabaseRequest(this.getTopic(), this.getPageSize(), newStartMarker);
    }

    public PutEventsRequestEntry createNewEventEntry(String eventBusName, String detailType, String invokedFunctionArn) {
        return (PutEventsRequestEntry)PutEventsRequestEntry.builder().eventBusName(eventBusName).detail(this.toJsonString()).detailType(detailType).resources(new String[]{invokedFunctionArn}).time(Instant.now()).source(invokedFunctionArn).build();
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getStartMarker(), this.getPageSize(), this.getTopic());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScanDatabaseRequest)) {
            return false;
        }
        ScanDatabaseRequest that = (ScanDatabaseRequest)o;
        return this.getPageSize() == that.getPageSize() && Objects.equals(this.getStartMarker(), that.getStartMarker()) && Objects.equals(this.getTopic(), that.getTopic());
    }

    private boolean pageSizeWithinLimits(int pageSize) {
        return pageSize > 0 && pageSize <= 1000;
    }
}

