/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.events.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import no.unit.nva.events.EventsConfig;
import no.unit.nva.events.models.EventBody;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.eventbridge.model.PutEventsRequestEntry;

public class ScanDatabaseRequestV2
implements EventBody {
    public static final String START_MARKER = "startMarker";
    public static final String PAGE_SIZE = "pageSize";
    public static final int DEFAULT_PAGE_SIZE = 700;
    public static final int MAX_PAGE_SIZE = 1000;
    public static final Map<String, AttributeValue> DYNAMODB_EMPTY_MARKER = null;
    @JsonProperty(value="startMarker")
    private Map<String, String> startMarker;
    @JsonProperty(value="pageSize")
    private Integer pageSize;
    @JsonProperty(value="topic")
    private String topic;

    public ScanDatabaseRequestV2() {
    }

    public ScanDatabaseRequestV2(String topic, Integer pageSize, Map<String, String> startMarker) {
        this.setPageSize(pageSize);
        this.setTopic(topic);
        this.setStartMarker(startMarker);
    }

    public static ScanDatabaseRequestV2 fromJson(String detail) {
        return (ScanDatabaseRequestV2)Try.attempt(() -> (ScanDatabaseRequestV2)EventsConfig.objectMapperLight.beanFrom(ScanDatabaseRequestV2.class, (Object)detail)).orElseThrow();
    }

    public Map<String, String> getStartMarker() {
        return this.startMarker;
    }

    public final void setStartMarker(Map<String, String> startMarker) {
        this.startMarker = startMarker;
    }

    public int getPageSize() {
        return Objects.nonNull(this.pageSize) ? this.pageSize : 700;
    }

    public final void setPageSize(int pageSize) {
        this.pageSize = this.isValid(pageSize) ? pageSize : 700;
    }

    public ScanDatabaseRequestV2 newScanDatabaseRequest(Map<String, AttributeValue> newStartMarker) {
        return new ScanDatabaseRequestV2(this.getTopic(), this.getPageSize(), this.toSerializableForm(newStartMarker));
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    public final void setTopic(String topic) {
        this.topic = topic;
    }

    @JsonIgnore
    public Map<String, AttributeValue> toDynamoScanMarker() {
        return Objects.nonNull(this.getStartMarker()) ? this.convertSerializableMarkerToDynamoDbMarker() : DYNAMODB_EMPTY_MARKER;
    }

    public PutEventsRequestEntry createNewEventEntry(String eventBusName, String detailType, String invokedFunctionArn) {
        return (PutEventsRequestEntry)PutEventsRequestEntry.builder().eventBusName(eventBusName).detail(this.toString()).detailType(detailType).resources(new String[]{invokedFunctionArn}).time(Instant.now()).source(invokedFunctionArn).build();
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getStartMarker(), this.getPageSize(), this.getTopic());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScanDatabaseRequestV2)) {
            return false;
        }
        ScanDatabaseRequestV2 that = (ScanDatabaseRequestV2)o;
        return this.getPageSize() == that.getPageSize() && Objects.equals(this.getStartMarker(), that.getStartMarker()) && Objects.equals(this.getTopic(), that.getTopic());
    }

    public String toString() {
        return (String)Try.attempt(() -> EventsConfig.objectMapperLight.asString((Object)this)).orElseThrow();
    }

    private Map<String, AttributeValue> convertSerializableMarkerToDynamoDbMarker() {
        return this.getStartMarker().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.createAttributeValue((String)e.getValue())));
    }

    private boolean isValid(Integer pageSize) {
        return Objects.nonNull(pageSize) && pageSize > 0 && pageSize < 1000;
    }

    private Map<String, String> toSerializableForm(Map<String, AttributeValue> newStartMarker) {
        return newStartMarker.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AttributeValue)entry.getValue()).s()));
    }

    private AttributeValue createAttributeValue(String value) {
        return (AttributeValue)AttributeValue.builder().s(value).build();
    }
}

