/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.events.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Objects;
import no.unit.nva.commons.json.JsonSerializable;
import no.unit.nva.events.EventsConfig;
import no.unit.nva.events.models.EventBody;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;

public class EventReference
implements JsonSerializable,
EventBody {
    public static final String TOPIC = "topic";
    public static final String URI = "uri";
    public static final String SUBTOPIC = "subtopic";
    @JsonProperty(value="topic")
    private final String topic;
    @JsonProperty(value="subtopic")
    private final String subtopic;
    @JsonProperty(value="uri")
    private final URI uri;

    @JsonCreator
    public EventReference(@JsonProperty(value="topic") String topic, @JsonProperty(value="subtopic") String subtopic, @JsonProperty(value="uri") URI uri) {
        this.topic = topic;
        this.subtopic = subtopic;
        this.uri = uri;
    }

    public EventReference(String topic, URI uri) {
        this(topic, null, uri);
    }

    public static EventReference fromJson(String json) {
        return (EventReference)Try.attempt(() -> (EventReference)EventsConfig.objectMapper.readValue(json, EventReference.class)).orElseThrow();
    }

    @JacocoGenerated
    public String getSubtopic() {
        return this.subtopic;
    }

    @Override
    @JacocoGenerated
    public String getTopic() {
        return this.topic;
    }

    @JacocoGenerated
    public URI getUri() {
        return this.uri;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getTopic(), this.getUri());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventReference)) {
            return false;
        }
        EventReference that = (EventReference)o;
        return Objects.equals(this.getTopic(), that.getTopic()) && Objects.equals(this.getUri(), that.getUri());
    }
}

