/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.events.handlers;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import no.unit.nva.events.EventsConfig;
import no.unit.nva.events.models.ScanDatabaseRequest;
import nva.commons.core.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;
import software.amazon.awssdk.services.eventbridge.model.PutEventsRequest;
import software.amazon.awssdk.services.eventbridge.model.PutEventsRequestEntry;

public abstract class StartBatchScanHandler
implements RequestStreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(StartBatchScanHandler.class);
    private static final String EVENT_BUS = new Environment().readEnv("EVENT_BUS");
    private static final String SCAN_REQUEST_EVENTS_DETAIL_TYPE = "topicInDetailType";
    private final EventBridgeClient eventClient;

    protected StartBatchScanHandler(EventBridgeClient eventClient) {
        this.eventClient = eventClient;
    }

    public void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        ScanDatabaseRequest requestSentByUser = this.parseUserInput(input);
        ScanDatabaseRequest requestWithTopic = this.createEventAsExpectedByEventListener(requestSentByUser);
        this.emitEvent(context, requestWithTopic);
        logger.info("Emitted request {}", (Object)requestWithTopic.toJsonString());
    }

    protected abstract String getScanEventTopic();

    private ScanDatabaseRequest parseUserInput(InputStream input) throws IOException {
        return (ScanDatabaseRequest)EventsConfig.objectMapper.readValue(input, ScanDatabaseRequest.class);
    }

    private ScanDatabaseRequest createEventAsExpectedByEventListener(ScanDatabaseRequest input) {
        return new ScanDatabaseRequest(this.getScanEventTopic(), input.getPageSize(), input.getStartMarker());
    }

    private void emitEvent(Context context, ScanDatabaseRequest requestWithTopic) {
        this.eventClient.putEvents(this.createEvent(context, requestWithTopic));
    }

    private PutEventsRequest createEvent(Context context, ScanDatabaseRequest request) {
        return (PutEventsRequest)PutEventsRequest.builder().entries(new PutEventsRequestEntry[]{this.createNewEventEntry(context, request)}).build();
    }

    private PutEventsRequestEntry createNewEventEntry(Context context, ScanDatabaseRequest request) {
        return request.createNewEventEntry(EVENT_BUS, SCAN_REQUEST_EVENTS_DETAIL_TYPE, context.getInvokedFunctionArn());
    }
}

