/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.events.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.time.Instant;
import java.util.Objects;
import no.unit.nva.commons.json.JsonSerializable;
import no.unit.nva.commons.json.JsonUtils;
import no.unit.nva.events.EventsConfig;
import no.unit.nva.events.models.EventBody;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;

public class EventReference
implements JsonSerializable,
EventBody {
    public static final String TOPIC = "topic";
    public static final String URI = "uri";
    public static final String SUBTOPIC = "subtopic";
    public static final String TIMESTAMP = "timestamp";
    @JsonProperty(value="topic")
    private final String topic;
    @JsonProperty(value="subtopic")
    private final String subtopic;
    @JsonProperty(value="uri")
    private final URI uri;
    @JsonProperty(value="timestamp")
    private final Instant timestamp;

    @JsonCreator
    public EventReference(@JsonProperty(value="topic") String topic, @JsonProperty(value="subtopic") String subtopic, @JsonProperty(value="uri") URI uri, @JsonProperty(value="timestamp") Instant timestamp) {
        this.topic = topic;
        this.subtopic = subtopic;
        this.uri = uri;
        this.timestamp = timestamp;
    }

    public EventReference(String topic, String subtopic, URI uri) {
        this(topic, subtopic, uri, Instant.now());
    }

    public EventReference(String topic, URI uri) {
        this(topic, null, uri);
    }

    public static EventReference fromJson(String json) {
        return (EventReference)Try.attempt(() -> (EventReference)EventsConfig.objectMapper.readValue(json, EventReference.class)).orElseThrow();
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    @JacocoGenerated
    public String getSubtopic() {
        return this.subtopic;
    }

    @Override
    @JacocoGenerated
    public String getTopic() {
        return this.topic;
    }

    @JacocoGenerated
    public URI getUri() {
        return this.uri;
    }

    public String extractBucketName() {
        return this.uri.getHost();
    }

    public String toJsonString() {
        try {
            return JsonUtils.singleLineObjectMapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventReference)) {
            return false;
        }
        EventReference that = (EventReference)o;
        return Objects.equals(this.getTopic(), that.getTopic()) && Objects.equals(this.getSubtopic(), that.getSubtopic()) && Objects.equals(this.getUri(), that.getUri()) && Objects.equals(this.getTimestamp(), that.getTimestamp());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getTopic(), this.getSubtopic(), this.getUri(), this.getTimestamp());
    }
}

