/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.language;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import no.unit.nva.language.Language;
import no.unit.nva.language.LanguageConstants;
import no.unit.nva.language.tooling.JacocoGenerated;

public final class LanguageMapper {
    private static final List<Language> languages = LanguageConstants.ALL_LANGUAGES;
    public static final String EMPTY_STRING = "";

    @JacocoGenerated
    private LanguageMapper() {
    }

    public static Language getLanguageByIso6391Code(String code) {
        return LanguageMapper.mappedValue(languages.stream().filter(language -> LanguageMapper.convertString(code).equalsIgnoreCase(language.getIso6391Code())));
    }

    public static Language getLanguageByIso6392Code(String code) {
        return LanguageMapper.mappedValue(languages.stream().filter(language -> language.getIso6392Code().stream().anyMatch(lang -> LanguageMapper.convertString(code).equalsIgnoreCase((String)lang))));
    }

    public static Language getLanguageByIso6393Code(String code) {
        return LanguageMapper.mappedValue(languages.stream().filter(language -> LanguageMapper.convertString(code).equalsIgnoreCase(language.getIso6393Code())));
    }

    public static Language getLanguageByEnglishName(String name) {
        return LanguageMapper.mappedValue(languages.stream().filter(language -> LanguageMapper.convertString(name).equalsIgnoreCase(language.getEng())));
    }

    public static Language getLanguageByBokmaalName(String name) {
        return LanguageMapper.mappedValue(languages.stream().filter(language -> LanguageMapper.convertString(name).equalsIgnoreCase(language.getNob())));
    }

    public static Language getLanguageByNynorskName(String name) {
        return LanguageMapper.mappedValue(languages.stream().filter(language -> LanguageMapper.convertString(name).equalsIgnoreCase(language.getNno())));
    }

    public static Language getLanguageBySamiName(String name) {
        return LanguageMapper.mappedValue(languages.stream().filter(language -> LanguageMapper.convertString(name).equalsIgnoreCase(language.getSme())));
    }

    public static Language getLanguageByUri(URI uri) {
        return LanguageMapper.mappedValue(LanguageConstants.ALL_LANGUAGES.stream().filter(language -> uri.equals(language.getLexvoUri())));
    }

    private static Language mappedValue(Stream<Language> stream) {
        return stream.findAny().map(LanguageMapper::replaceNorwegian).map(LanguageMapper::replaceMiscellaneous).orElse(LanguageConstants.UNDEFINED_LANGUAGE);
    }

    private static Language replaceMiscellaneous(Language language) {
        if (LanguageConstants.MISCELLANEOUS.equals(language)) {
            return LanguageConstants.MULTIPLE;
        }
        return language;
    }

    private static Language replaceNorwegian(Language language) {
        if (LanguageConstants.NORWEGIAN.equals(language)) {
            return LanguageConstants.BOKMAAL;
        }
        return language;
    }

    private static String convertString(String code) {
        return Objects.nonNull(code) ? code.trim() : EMPTY_STRING;
    }
}

