/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.language;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import no.unit.nva.language.LanguageDescription;
import no.unit.nva.language.tooling.JacocoGenerated;

public class LanguageGroup
implements LanguageDescription {
    public static final String ISO_639_5 = "iso639-5";
    private static final String DOES_NOT_HAVE_ISO_639_1 = null;
    private static final List<String> DOES_NOT_HAVE_ISO_639_2 = Collections.emptyList();
    private static final String DOES_NOT_HAVE_ISO_639_3 = null;
    private final String eng;
    private final String nob;
    private final String nno;
    private final String sme;
    private final String iso6395Code;

    public LanguageGroup(String eng, String nob, String nno, String sme, String iso6395Code) {
        this.eng = eng;
        this.nob = nob;
        this.nno = nno;
        this.sme = sme;
        this.iso6395Code = iso6395Code;
    }

    @Override
    public String getEng() {
        return this.eng;
    }

    @Override
    public String getNob() {
        return this.nob;
    }

    @Override
    public String getNno() {
        return this.nno;
    }

    @Override
    public String getSme() {
        return this.sme;
    }

    @Override
    public URI getLexvoUri() {
        return this.generateLexvoUri(this.iso6395Code, ISO_639_5);
    }

    @Override
    public String getIso6391Code() {
        return DOES_NOT_HAVE_ISO_639_1;
    }

    @Override
    public List<String> getIso6392Code() {
        return DOES_NOT_HAVE_ISO_639_2;
    }

    @Override
    public String getIso6393Code() {
        return DOES_NOT_HAVE_ISO_639_3;
    }

    @Override
    public String getIso6395Code() {
        return this.iso6395Code;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LanguageGroup)) {
            return false;
        }
        LanguageGroup that = (LanguageGroup)o;
        return Objects.equals(this.getEng(), that.getEng()) && Objects.equals(this.getNob(), that.getNob()) && Objects.equals(this.getNno(), that.getNno()) && Objects.equals(this.getSme(), that.getSme()) && Objects.equals(this.getIso6395Code(), that.getIso6395Code());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getEng(), this.getNob(), this.getNno(), this.getSme(), this.getIso6395Code());
    }
}

