/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.language;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import no.unit.nva.language.Language;
import no.unit.nva.language.LanguageConstants;
import no.unit.nva.language.LanguageDescription;
import no.unit.nva.language.LanguageGroup;
import no.unit.nva.language.tooling.JacocoGenerated;

public final class LanguageMapper {
    private static final List<LanguageDescription> languages = LanguageConstants.ALL_LANGUAGES;
    public static final String EMPTY_STRING = "";

    @JacocoGenerated
    private LanguageMapper() {
    }

    public static Language getLanguageByIso6391Code(String code) {
        return (Language)LanguageMapper.mappedValue(languages.stream().filter(language -> LanguageMapper.convertString(code).equalsIgnoreCase(language.getIso6391Code())));
    }

    public static Language getLanguageByIso6392Code(String code) {
        return (Language)LanguageMapper.mappedValue(languages.stream().filter(language -> language.getIso6392Code().stream().anyMatch(lang -> LanguageMapper.convertString(code).equalsIgnoreCase((String)lang))));
    }

    public static Language getLanguageByIso6393Code(String code) {
        return (Language)LanguageMapper.mappedValue(languages.stream().filter(language -> LanguageMapper.convertString(code).equalsIgnoreCase(language.getIso6393Code())));
    }

    public static LanguageDescription getLanguageByEnglishName(String name) {
        return LanguageMapper.mappedValue(languages.stream().filter(language -> LanguageMapper.convertString(name).equalsIgnoreCase(language.getEng())));
    }

    public static LanguageDescription getLanguageByBokmaalName(String name) {
        return LanguageMapper.mappedValue(languages.stream().filter(language -> LanguageMapper.convertString(name).equalsIgnoreCase(language.getNob())));
    }

    public static LanguageDescription getLanguageByNynorskName(String name) {
        return LanguageMapper.mappedValue(languages.stream().filter(language -> LanguageMapper.convertString(name).equalsIgnoreCase(language.getNno())));
    }

    public static LanguageDescription getLanguageBySamiName(String name) {
        return LanguageMapper.mappedValue(languages.stream().filter(language -> LanguageMapper.convertString(name).equalsIgnoreCase(language.getSme())));
    }

    public static LanguageDescription getLanguageByUri(URI uri) {
        return LanguageMapper.mappedValue(LanguageConstants.ALL_LANGUAGES.stream().filter(language -> uri.equals(language.getLexvoUri())));
    }

    public static LanguageGroup getLanguageByIso6395Code(String iso6395Code) {
        return (LanguageGroup)LanguageMapper.mappedValue(languages.stream().filter(language -> iso6395Code.equals(language.getIso6395Code())));
    }

    public static LanguageDescription getLanguageByPotentialIsoCode(String potentialIsoCode) {
        return LanguageMapper.mappedValue(languages.stream().filter(language -> LanguageMapper.matchesCode(potentialIsoCode, language)));
    }

    private static boolean matchesCode(String potentialIsoCode, LanguageDescription language) {
        return potentialIsoCode.equalsIgnoreCase(language.getIso6391Code()) || LanguageMapper.iso6392CodesContains(potentialIsoCode, language.getIso6392Code()) || potentialIsoCode.equalsIgnoreCase(language.getIso6393Code()) || potentialIsoCode.equalsIgnoreCase(language.getIso6395Code());
    }

    private static boolean iso6392CodesContains(String potentialIsoCode, List<String> iso6392Code) {
        return iso6392Code.stream().anyMatch(potentialIsoCode::equalsIgnoreCase);
    }

    private static LanguageDescription mappedValue(Stream<LanguageDescription> stream) {
        return stream.findAny().map(LanguageMapper::replaceNorwegian).map(LanguageMapper::replaceMiscellaneous).orElse(LanguageConstants.UNDEFINED_LANGUAGE);
    }

    private static LanguageDescription replaceMiscellaneous(LanguageDescription language) {
        if (LanguageConstants.MISCELLANEOUS.equals(language)) {
            return LanguageConstants.MULTIPLE;
        }
        return language;
    }

    private static LanguageDescription replaceNorwegian(LanguageDescription language) {
        if (LanguageConstants.NORWEGIAN.equals(language)) {
            return LanguageConstants.BOKMAAL;
        }
        return language;
    }

    private static String convertString(String code) {
        return Objects.nonNull(code) ? code.trim() : EMPTY_STRING;
    }
}

