/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.application;

import ch.supertomcat.supertomcatutils.application.ApplicationProperties;
import ch.supertomcat.supertomcatutils.application.ApplicationUtil;
import ch.supertomcat.supertomcatutils.io.FileUtil;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.LoggerFactory;

public abstract class ApplicationMain {
    protected final String applicationShortName;
    protected final Image applicationIcon;
    protected final boolean gui;
    protected final boolean singleInstance;
    protected final Class<?> mainClass;
    protected final Set<String> additionalPaths = new LinkedHashSet<String>();
    protected final Set<String> overwritablePaths = new LinkedHashSet<String>();
    protected final List<Thread> shutdownHookThreads = new CopyOnWriteArrayList<Thread>();

    public ApplicationMain(String applicationShortName, Image applicationIcon, boolean gui, boolean singleInstance, Class<?> mainClass) {
        this(applicationShortName, applicationIcon, gui, singleInstance, mainClass, Collections.emptyList(), Collections.emptyList());
    }

    public ApplicationMain(String applicationShortName, Image applicationIcon, boolean gui, boolean singleInstance, Class<?> mainClass, List<String> additionalPaths) {
        this(applicationShortName, applicationIcon, gui, singleInstance, mainClass, additionalPaths, Collections.emptyList());
    }

    public ApplicationMain(String applicationShortName, Image applicationIcon, boolean gui, boolean singleInstance, Class<?> mainClass, List<String> additionalPaths, List<String> overwritablePaths) {
        this.applicationShortName = applicationShortName;
        this.applicationIcon = applicationIcon;
        this.gui = gui;
        this.singleInstance = singleInstance;
        this.mainClass = mainClass;
        this.additionalPaths.addAll(additionalPaths);
        if (overwritablePaths.isEmpty()) {
            this.overwritablePaths.add("LogsPath");
            this.overwritablePaths.addAll(additionalPaths);
        } else {
            this.overwritablePaths.addAll(overwritablePaths);
        }
    }

    public void start(String[] args) {
        this.initializeApplicationProperties();
        this.initializeJarFilenameAndApplicationPathProperties();
        String programUserDir = System.getProperty("user.home") + FileUtil.FILE_SEPERATOR + "." + ApplicationProperties.getProperty("ApplicationShortName") + FileUtil.FILE_SEPERATOR;
        this.initializeProfileAndLogsPathProperties(programUserDir);
        this.initializeAdditionalPathProperties(programUserDir);
        this.parseDefaultCommandLine(args);
        this.overrideDirectoryProperties();
        this.initializeLogging();
        if (this.singleInstance) {
            this.ensureSingleInstance(programUserDir, ApplicationProperties.getProperty("ApplicationShortName") + ".lock");
        }
        ApplicationUtil.logApplicationInfo();
        this.deleteOldLogFiles();
        if (this.gui) {
            this.setSystemLookAndFeel();
        }
        this.main(args);
    }

    public void exit() {
        this.exit(0, false);
    }

    public void exit(boolean restart) {
        this.exit(0, restart);
    }

    public void exit(int exitCode) {
        this.exit(exitCode, false);
    }

    public void exit(int exitCode, boolean restart) {
        if (this.singleInstance) {
            this.releaseSingleInstanceLockFile();
        }
        if (restart) {
            this.restartApplication();
        }
        this.exitNow(exitCode);
    }

    protected boolean restartApplication() {
        if (!ApplicationProperties.getProperty("JarFilename").isEmpty()) {
            try {
                Object applicationAbsolutePath = new File(ApplicationProperties.getProperty("ApplicationPath")).getAbsolutePath();
                if (!((String)applicationAbsolutePath).endsWith(FileUtil.FILE_SEPERATOR)) {
                    applicationAbsolutePath = (String)applicationAbsolutePath + FileUtil.FILE_SEPERATOR;
                }
                String jreJavaw = System.getProperty("java.home") + FileUtil.FILE_SEPERATOR + "bin" + FileUtil.FILE_SEPERATOR + "javaw";
                String jreJava = System.getProperty("java.home") + FileUtil.FILE_SEPERATOR + "bin" + FileUtil.FILE_SEPERATOR + "java";
                String os = System.getProperty("os.name").toLowerCase();
                File fJreJavaw = new File(os.contains("windows") ? jreJavaw + ".exe" : jreJavaw);
                File fJreJava = new File(os.contains("windows") ? jreJava + ".exe" : jreJava);
                ArrayList<String> arguments = new ArrayList<String>();
                if (fJreJavaw.exists()) {
                    arguments.add(jreJavaw);
                } else if (fJreJava.exists()) {
                    arguments.add(jreJava);
                }
                if (arguments.isEmpty()) {
                    return false;
                }
                arguments.add("-jar");
                arguments.add((String)applicationAbsolutePath + ApplicationProperties.getProperty("JarFilename"));
                new ProcessBuilder(arguments).start();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not restart application", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    protected void exitNow(int exitCode) {
        LoggerFactory.getLogger(this.getClass()).debug("Exit now!");
        System.exit(exitCode);
    }

    protected void initializeApplicationProperties() {
        try (InputStream in = this.mainClass.getResourceAsStream("/Application_Config.properties");){
            ApplicationProperties.initProperties(in);
        }
        catch (IOException e) {
            this.logStartupError("Could not initialize application properties", e);
            System.exit(1);
        }
    }

    protected void initializeJarFilenameAndApplicationPathProperties() {
        String jarFilename = ApplicationUtil.getThisApplicationsJarFilename(this.mainClass);
        ApplicationProperties.setProperty("JarFilename", jarFilename);
        String appPath = ApplicationUtil.getThisApplicationsPath((String)(!jarFilename.isEmpty() ? jarFilename : ApplicationProperties.getProperty("ApplicationShortName") + ".jar"));
        ApplicationProperties.setProperty("ApplicationPath", appPath);
    }

    protected void initializeProfileAndLogsPathProperties(String programUserDir) {
        ApplicationProperties.setProperty("ProfilePath", programUserDir);
        ApplicationProperties.setProperty("LogsPath", programUserDir);
    }

    protected void initializeAdditionalPathProperties(String programUserDir) {
        for (String additionalPath : this.additionalPaths) {
            ApplicationProperties.setProperty(additionalPath, programUserDir);
        }
    }

    protected void overrideDirectoryProperties() {
        try {
            Properties directoriesProperties = this.readDirectoriesFile();
            if (directoriesProperties == null) {
                return;
            }
            for (String overwriteablePath : this.overwritablePaths) {
                String dir = directoriesProperties.getProperty(overwriteablePath);
                if (dir == null || dir.isEmpty()) continue;
                ApplicationProperties.setProperty(overwriteablePath, dir);
            }
        }
        catch (IOException e) {
            this.logStartupError("Could not read directories.properties", e);
            System.exit(1);
        }
    }

    protected Properties readDirectoriesFile() throws IOException {
        File file = new File(ApplicationProperties.getProperty("ApplicationPath") + "directories.properties");
        if (!file.exists()) {
            return null;
        }
        String content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        Properties directoriesProperties = new Properties();
        directoriesProperties.load(new StringReader(content.replace("\\", "\\\\")));
        return directoriesProperties;
    }

    protected void initializeLogging() {
        String logFilename = ApplicationProperties.getProperty("ApplicationShortName") + ".log";
        System.setProperty("applicationlog4jlogfile", ApplicationProperties.getProperty("LogsPath") + FileUtil.FILE_SEPERATOR + logFilename);
        LoggerFactory.getLogger(this.mainClass);
        ApplicationUtil.initializeSLF4JUncaughtExceptionHandler();
    }

    protected void parseDefaultCommandLine(String[] args) {
        for (String arg : args) {
            if (arg.equalsIgnoreCase("-version")) {
                System.out.print(ApplicationProperties.getProperty("ApplicationVersion"));
                System.exit(0);
                continue;
            }
            if (arg.equalsIgnoreCase("-versionNumber")) {
                System.out.print(ApplicationProperties.getProperty("ApplicationVersion").replace(".", ""));
                System.exit(0);
                continue;
            }
            if (!arg.equalsIgnoreCase("-help")) continue;
            String help = ApplicationProperties.getProperty("ApplicationName") + " v" + ApplicationProperties.getProperty("ApplicationVersion") + "\n\n";
            help = help + "Command Line Arguments:\n";
            help = help + "-version\t\tPrints the Version of the program (e.g. 1.2.0)\n\n";
            help = help + "-versionNumber\t\tPrints the VersionNumber of the program (e.g. 120)\n\n";
            System.out.print(help);
            System.exit(0);
        }
    }

    protected void ensureSingleInstance(String lockFileDirectory, String lockFilename) {
        if (!ApplicationUtil.lockLockFile(lockFileDirectory, lockFilename)) {
            if (this.gui) {
                this.displayStartupError("Another Instance of the Application is running. Application is terminating.");
            } else {
                LoggerFactory.getLogger(this.mainClass).error("Another Instance of the Application is running. Application is terminating.");
            }
            System.exit(0);
        }
    }

    public void releaseSingleInstanceLockFile() {
        LoggerFactory.getLogger(this.getClass()).debug("Releasing Lockfile");
        ApplicationUtil.releaseLockFile();
    }

    protected void logStartupError(String message, Throwable t) {
        System.err.println(message);
        t.printStackTrace();
        ApplicationUtil.writeBasicErrorLogfile(new File(this.applicationShortName + "-Error.log"), message + ":\n" + ApplicationUtil.formatStackTrace(t));
    }

    protected void displayStartupError(String message) {
        JFrame frame = null;
        try {
            frame = ApplicationUtil.createInvisibleFrame(this.applicationShortName, this.applicationIcon);
            JOptionPane.showMessageDialog(frame, message, "Error", 0);
        }
        finally {
            if (frame != null) {
                frame.dispose();
            }
        }
    }

    protected void deleteOldLogFiles() {
        String logFilename = ApplicationProperties.getProperty("ApplicationShortName") + ".log";
        ApplicationUtil.deleteOldLogFiles(7, logFilename, ApplicationProperties.getProperty("LogsPath"));
    }

    protected boolean setSystemLookAndFeel() {
        return this.changeLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    protected boolean changeLookAndFeel(String lookAndFeelClassName) {
        try {
            UIManager.setLookAndFeel(lookAndFeelClassName);
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not set look and feel: {}", (Object)lookAndFeelClassName, (Object)e);
            return false;
        }
    }

    protected void addDefaultShutdownHook() {
        Thread shutdownThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ApplicationMain.this.shutdownHookExit();
            }
        });
        shutdownThread.setName("Shutdown-Thread-" + shutdownThread.getId());
        this.addShutdownHook(shutdownThread);
    }

    protected void shutdownHookExit() {
        this.exit();
    }

    protected void addShutdownHook(Thread shutdownHookThread) {
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
        if (!this.shutdownHookThreads.contains(shutdownHookThread)) {
            this.shutdownHookThreads.add(shutdownHookThread);
        }
    }

    protected void removeShutdownHook(Thread shutdownHookThread) {
        Runtime.getRuntime().removeShutdownHook(shutdownHookThread);
        this.shutdownHookThreads.remove(shutdownHookThread);
    }

    protected void removeAllShutdownHooks() {
        for (Thread shutdownHookThread : this.shutdownHookThreads) {
            Runtime.getRuntime().removeShutdownHook(shutdownHookThread);
        }
        this.shutdownHookThreads.clear();
    }

    protected abstract void main(String[] var1);
}

