/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Icons {
    private static final String APPL_ICON_RESOURCE_FORMAT = "/" + Icons.class.getPackage().getName().replace(".", "/") + "/icons/%s";
    private static final String APPL_ICON_SIZE_RESOURCE_FORMAT = "/" + Icons.class.getPackage().getName().replace(".", "/") + "/icons/%dx%d/%s";
    private static final String TANGO_ICON_RESOURCE_FORMAT = "/org/freedesktop/tango/%dx%d/%s";
    private static Map<String, Image> iconCache = new HashMap<String, Image>();
    private static Logger logger = LoggerFactory.getLogger(Icons.class);
    private static Image dummy16 = Icons.getApplImage("dummy.png", 16);
    private static Image dummy22 = Icons.getApplImage("dummy.png", 22);
    private static Image dummy32 = Icons.getApplImage("dummy.png", 32);

    private Icons() {
    }

    public static synchronized ImageIcon getTangoIcon(String resource, int size) {
        return Icons.getIcon(String.format(TANGO_ICON_RESOURCE_FORMAT, size, size, resource));
    }

    public static synchronized Image getTangoImage(String resource, int size) {
        return Icons.getImage(String.format(TANGO_ICON_RESOURCE_FORMAT, size, size, resource));
    }

    public static synchronized ImageIcon getApplIcon(String resource) {
        return Icons.getIcon(String.format(APPL_ICON_RESOURCE_FORMAT, resource));
    }

    public static synchronized ImageIcon getApplIcon(String resource, int size) {
        return Icons.getIcon(String.format(APPL_ICON_SIZE_RESOURCE_FORMAT, size, size, resource));
    }

    public static synchronized Image getApplImage(String resource) {
        return Icons.getImage(String.format(APPL_ICON_RESOURCE_FORMAT, resource));
    }

    public static synchronized Image getApplImage(String resource, int size) {
        return Icons.getImage(String.format(APPL_ICON_SIZE_RESOURCE_FORMAT, size, size, resource));
    }

    public static synchronized ImageIcon getIcon(String resource) {
        return new ImageIcon(Icons.getImage(resource));
    }

    public static synchronized Image getImage(String resource) {
        Image image = iconCache.get(resource);
        if (image == null) {
            image = Icons.loadImage(resource);
            if (image != null) {
                iconCache.put(resource, image);
            } else {
                logger.error("Could not load image: {}", (Object)resource);
            }
        }
        return image;
    }

    private static Image loadImage(String resource) {
        try {
            URL resourceURL = Icons.class.getResource(resource);
            if (resourceURL != null) {
                return Toolkit.getDefaultToolkit().getImage(resourceURL);
            }
            logger.error("Could not load image: {}", (Object)resource);
        }
        catch (Exception e) {
            logger.error("Could not load image: {}", (Object)resource, (Object)e);
        }
        return dummy16;
    }

    public static Image getDummyImage(int size) {
        if (size >= 32) {
            return dummy32;
        }
        if (size >= 22 && size < 32) {
            return dummy22;
        }
        return dummy16;
    }
}

