/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;

public final class PositionUtil {
    private PositionUtil() {
    }

    public static void setPositionMiddleScreen(Window window, Component parent) {
        if (window == null) {
            return;
        }
        GraphicsDevice device = PositionUtil.getScreenDeviceOfComponent(parent);
        if (device != null) {
            Rectangle screenBounds = device.getDefaultConfiguration().getBounds();
            Point screenCenterPoint = PositionUtil.getCenterPoint(screenBounds);
            int screenX = screenBounds.x;
            int screenY = screenBounds.y;
            int screenCenterX = screenCenterPoint.x;
            int screenCenterY = screenCenterPoint.y;
            int screenWidth = screenBounds.width;
            int screenHeight = screenBounds.height;
            int windowWidth = window.getWidth();
            int windowHeight = window.getHeight();
            int targetX = screenCenterX - windowWidth / 2;
            int targetY = screenCenterY - windowHeight / 2;
            if (targetY + windowHeight > screenY + screenHeight) {
                targetY = screenY + screenHeight - windowHeight;
            }
            if (targetY < screenY) {
                targetY = screenY;
            }
            if (targetX + windowWidth > screenX + screenWidth) {
                targetX = screenX + screenWidth - windowWidth;
            }
            if (targetX < screenX) {
                targetX = screenX;
            }
            window.setLocation(targetX, targetY);
        } else {
            window.setLocationRelativeTo(null);
        }
    }

    public static GraphicsDevice getScreenDeviceOfComponent(Component comp) {
        if (comp == null) {
            return null;
        }
        GraphicsConfiguration graphicsConfig = comp.getGraphicsConfiguration();
        if (graphicsConfig != null) {
            return graphicsConfig.getDevice();
        }
        return null;
    }

    public static Point getCenterPoint(Rectangle bounds) {
        return PositionUtil.getCenterPoint(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public static Point getCenterPoint(int x, int y, int width, int height) {
        return new Point(x + width / 2, y + height / 2);
    }
}

