/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.copyandpaste;

import ch.supertomcat.supertomcatutils.gui.Icons;
import ch.supertomcat.supertomcatutils.gui.Localization;
import ch.supertomcat.supertomcatutils.gui.copyandpaste.CopyAction;
import ch.supertomcat.supertomcatutils.gui.copyandpaste.DeleteAction;
import ch.supertomcat.supertomcatutils.gui.copyandpaste.PasteAction;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public final class JTextComponentCopyAndPaste {
    private static final CopyAndPasteMouseAdapter mouseListener = new CopyAndPasteMouseAdapter();
    private static final ImageIcon COPY_ICON = Icons.getTangoIcon("actions/edit-copy.png", 16);
    private static final ImageIcon PASTE_ICON = Icons.getTangoIcon("actions/edit-paste.png", 16);
    private static final ImageIcon DELETE_ICON = Icons.getTangoIcon("actions/edit-delete.png", 16);

    private JTextComponentCopyAndPaste() {
    }

    public static synchronized void addCopyAndPasteMouseListener(JTextComponent txtComp) {
        MouseListener[] listeners;
        for (MouseListener listener : listeners = txtComp.getMouseListeners()) {
            if (listener != mouseListener) continue;
            return;
        }
        txtComp.addMouseListener(mouseListener);
    }

    public static synchronized void removeCopyAndPasteMouseListener(JTextComponent txtComp) {
        txtComp.removeMouseListener(mouseListener);
    }

    private static class CopyAndPasteMouseAdapter
    extends MouseAdapter {
        private CopyAndPasteMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopupMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopupMenu(e);
            }
        }

        private void showPopupMenu(MouseEvent e) {
            if (!(e.getSource() instanceof JTextComponent)) {
                return;
            }
            JTextComponent txtField = (JTextComponent)e.getSource();
            if (!txtField.isEnabled()) {
                return;
            }
            boolean editable = txtField.isEditable();
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem menuItemCopy = new JMenuItem(Localization.getString("Copy"));
            JMenuItem menuItemPaste = new JMenuItem(Localization.getString("Paste"));
            JMenuItem menuItemDelete = new JMenuItem(Localization.getString("Delete"));
            menuItemCopy.setAction(new CopyAction(txtField));
            menuItemPaste.setAction(new PasteAction(txtField));
            menuItemPaste.setEnabled(editable);
            menuItemDelete.setAction(new DeleteAction(txtField));
            menuItemDelete.setEnabled(editable);
            menuItemCopy.setIcon(COPY_ICON);
            menuItemPaste.setIcon(PASTE_ICON);
            menuItemDelete.setIcon(DELETE_ICON);
            popupMenu.add(menuItemCopy);
            popupMenu.add(menuItemPaste);
            popupMenu.add(menuItemDelete);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

