/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.progress;

import ch.supertomcat.supertomcatutils.gui.progress.IProgressObserver;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ProgressObserver {
    private List<IProgressObserver> listeners = new CopyOnWriteArrayList<IProgressObserver>();

    public void progressIncreased() {
        for (IProgressObserver listener : this.listeners) {
            listener.progressIncreased();
        }
    }

    public void progressChanged(int val) {
        for (IProgressObserver listener : this.listeners) {
            listener.progressChanged(val);
        }
    }

    public void progressChanged(int min, int max, int val) {
        for (IProgressObserver listener : this.listeners) {
            listener.progressChanged(min, max, val);
        }
    }

    public void progressChanged(String text) {
        for (IProgressObserver listener : this.listeners) {
            listener.progressChanged(text);
        }
    }

    public void progressChanged(boolean visible) {
        for (IProgressObserver listener : this.listeners) {
            listener.progressChanged(visible);
        }
    }

    public void progressModeChanged(boolean indeterminate) {
        for (IProgressObserver listener : this.listeners) {
            listener.progressModeChanged(indeterminate);
        }
    }

    public void progressCompleted() {
        for (IProgressObserver listener : this.listeners) {
            listener.progressCompleted();
        }
    }

    public void addProgressListener(IProgressObserver l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeProgressListener(IProgressObserver l) {
        this.listeners.remove(l);
    }
}

