/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.table.hider;

import ch.supertomcat.supertomcatutils.gui.Localization;
import ch.supertomcat.supertomcatutils.gui.table.hider.TableColumnHider;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class TableHeaderColumnSelector {
    protected final TableColumnHider tableColumnHider;
    protected final JTable table;
    private JPopupMenu popupMenuTableHeader = new JPopupMenu();
    private final Map<String, JMenuItem> menuItems = new HashMap<String, JMenuItem>();

    public TableHeaderColumnSelector(TableColumnHider tableColumnHider, JTable table) {
        this.tableColumnHider = tableColumnHider;
        this.table = table;
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TableHeaderColumnSelector.this.showPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TableHeaderColumnSelector.this.showPopupMenu(e);
            }
        });
    }

    protected void showPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenuTableHeader.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void addColumn(Object identifier) {
        boolean visible = this.tableColumnHider.isVisible(identifier);
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.getLocalizedColumnName(identifier), visible);
        menuItem.addActionListener(e -> this.tableColumnHider.setVisible(identifier, menuItem.isSelected()));
        this.popupMenuTableHeader.add(menuItem);
        this.menuItems.put(String.valueOf(identifier), menuItem);
    }

    public String getLocalizedColumnName(Object identifier) {
        return Localization.getString(String.valueOf(identifier));
    }

    public void removeColumn(Object identifier) {
        JMenuItem menuItem = this.menuItems.remove(String.valueOf(identifier));
        if (menuItem != null) {
            this.popupMenuTableHeader.remove(menuItem);
        }
    }
}

