/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;

public final class HTMLUtil {
    private static final Pattern REGEX_ENCODING_PATTERN = Pattern.compile("<meta http-equiv=\"Content-Type\" content=\".*?; charset=(.*?)\" />");

    private HTMLUtil() {
    }

    public static String getEncodingFromSourceCode(String htmlCode) {
        Matcher matcher = REGEX_ENCODING_PATTERN.matcher(htmlCode);
        if (matcher.find()) {
            Matcher regionMatcher = REGEX_ENCODING_PATTERN.matcher(matcher.group());
            return regionMatcher.replaceAll("$1");
        }
        return "";
    }

    public static String escapeHTML(String input) {
        return StringEscapeUtils.escapeHtml4((String)input);
    }

    public static String unescapeHTML(String input) {
        return StringEscapeUtils.unescapeHtml4((String)input);
    }
}

