/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers;

import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.OperaCookie;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.OperaCookieHeader;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.OperaCookieInputStream;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.OperaDomain;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperaCookieRoot {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String file;
    private OperaCookieHeader och = new OperaCookieHeader();
    private List<OperaDomain> domains = new ArrayList<OperaDomain>();

    public OperaCookieRoot(String file) {
        this.file = file;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean read() {
        try (FileInputStream in = new FileInputStream(this.file);){
            OperaCookieInputStream oin;
            block14: {
                boolean bl;
                oin = new OperaCookieInputStream(in);
                try {
                    if (oin.read(this.och) != 12) break block14;
                    int tagSize = this.och.getTagSize();
                    int recordSize = this.och.getRecordSize();
                    this.domains.addAll(oin.readDomainComponents(tagSize, recordSize));
                    bl = true;
                }
                catch (Throwable throwable) {
                    try {
                        oin.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                oin.close();
                return bl;
            }
            this.logger.error("Could not read opera cookie file header");
            boolean bl = false;
            oin.close();
            return bl;
        }
        catch (IOException e) {
            this.logger.error("Could not read cookies from: {}", (Object)this.file, (Object)e);
            return false;
        }
    }

    public OperaCookieHeader getOch() {
        return this.och;
    }

    public List<OperaDomain> getDomains() {
        return this.domains;
    }

    public List<OperaCookie> getAllCookies() {
        ArrayList<OperaCookie> allCookies = new ArrayList<OperaCookie>();
        for (OperaDomain domain : this.domains) {
            allCookies.addAll(domain.getCookies(true));
        }
        return allCookies;
    }
}

