/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.http.cookies.webkit;

import ch.supertomcat.supertomcatutils.http.cookies.BrowserCookie;
import ch.supertomcat.supertomcatutils.io.CopyUtil;
import com.sun.jna.platform.win32.Crypt32Util;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebkitCookies {
    private static Logger logger = LoggerFactory.getLogger(WebkitCookies.class);
    private static final Object copyDBLock = new Object();
    private static final Object dbLock = new Object();
    private static long lastSqliteCopy = 0L;
    private static WebkitCookieComparator cookieComparator = new WebkitCookieComparator();

    private WebkitCookies() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BrowserCookie> getCookiesFromWebkit(String domain, String[] hosts, String[] paths, String cookieFile) {
        logger.debug("Cookiefile: {}", (Object)cookieFile);
        File file = new File(cookieFile);
        String newCookieFile = cookieFile + "bh_copy.sqlite";
        Object object = copyDBLock;
        synchronized (object) {
            if (System.currentTimeMillis() > lastSqliteCopy + 180000L) {
                CopyUtil.copy(cookieFile, newCookieFile);
                lastSqliteCopy = System.currentTimeMillis();
            }
        }
        try {
            return WebkitCookies.getCookiesFromWebkitSqlite(newCookieFile, domain, hosts, paths, dbLock);
        }
        catch (ClassNotFoundException | SQLException ex) {
            logger.error("Could not read cookies from: {}", (Object)file.getAbsolutePath(), (Object)ex);
            return new ArrayList<BrowserCookie>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BrowserCookie> getCookiesFromWebkitSqlite(String cookieFile, String domain, String[] hosts, String[] paths, Object dbLockObject) throws ClassNotFoundException, SQLException {
        int i;
        StringBuilder sbSQLQuery = new StringBuilder("SELECT * FROM cookies WHERE (host_key = '" + domain + "'");
        for (i = 0; i < hosts.length; ++i) {
            sbSQLQuery.append(" OR ");
            sbSQLQuery.append("host_key = '" + hosts[i] + "'");
        }
        sbSQLQuery.append(")");
        if (paths.length > 0) {
            sbSQLQuery.append(" AND (");
        }
        for (i = 0; i < paths.length; ++i) {
            sbSQLQuery.append("path = '" + paths[i] + "'");
            sbSQLQuery.append(" OR ");
            sbSQLQuery.append("path = '" + paths[i] + "/'");
            if (i >= paths.length - 1) continue;
            sbSQLQuery.append(" OR ");
        }
        if (paths.length > 0) {
            sbSQLQuery.append(")");
        }
        String sqlQuery = sbSQLQuery.toString();
        Class.forName("org.sqlite.JDBC");
        ArrayList<BrowserCookie> cookies = new ArrayList<BrowserCookie>();
        Object object = dbLockObject;
        synchronized (object) {
            logger.debug("SQL-Query: " + sqlQuery);
            try (Connection con = DriverManager.getConnection("jdbc:sqlite:" + cookieFile);
                 Statement stat = con.createStatement();
                 ResultSet rs = stat.executeQuery(sqlQuery);){
                while (rs.next()) {
                    String name = rs.getString("name");
                    String value = rs.getString("value");
                    String cookieDomain = rs.getString("host_key");
                    String path = rs.getString("path");
                    String strExpiryDate = rs.getString("expires_utc");
                    long expiryDate = Long.parseLong(strExpiryDate);
                    Instant expiryDateInstant = Instant.ofEpochMilli(expiryDate);
                    String strLastAccess = rs.getString("last_access_utc");
                    String strSecure = rs.getString("secure");
                    boolean secure = "1".equals(strSecure);
                    String strHttpOnly = rs.getString("httponly");
                    boolean httpOnly = "1".equals(strHttpOnly);
                    byte[] encryptedValue = rs.getBytes("encrypted_value");
                    String decryptedValue = WebkitCookies.decryptValue(encryptedValue, name, cookieDomain);
                    BrowserCookie cookie = new BrowserCookie(name, value);
                    cookie.setDomain(cookieDomain);
                    cookie.setPath(path);
                    cookie.setExpiryDate(expiryDateInstant);
                    cookie.setSecure(secure);
                    cookie.setHttpOnly(httpOnly);
                    if (decryptedValue != null) {
                        cookie.setValue(decryptedValue);
                    }
                    cookies.add(cookie);
                }
                logger.debug("Found cookies: {}", (Object)cookies.size());
            }
            catch (SQLException se) {
                logger.error("Could not read cookies from file: {}", (Object)cookieFile, (Object)se);
                throw se;
            }
        }
        Collections.sort(cookies, cookieComparator);
        return cookies;
    }

    private static String decryptValue(byte[] encryptedValue, String cookieName, String domain) {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            byte[] decryptedData = Crypt32Util.cryptUnprotectData((byte[])encryptedValue);
            return new String(decryptedData);
        }
        logger.error("Could not decrypt cookie value for cookie in domain '{}', because OS is not supported: {}", (Object)domain, (Object)cookieName);
        return null;
    }

    private static class WebkitCookieComparator
    implements Comparator<BrowserCookie> {
        private WebkitCookieComparator() {
        }

        @Override
        public int compare(BrowserCookie o1, BrowserCookie o2) {
            int nameComp = o1.getName().compareTo(o2.getName());
            if (nameComp == 0) {
                if (o1.getPath().length() > o2.getPath().length()) {
                    return -1;
                }
                if (o1.getPath().length() < o2.getPath().length()) {
                    return 1;
                }
                if (o1.getDomain().equals("." + o2.getDomain())) {
                    return 1;
                }
                if (o2.getDomain().equals("." + o1.getDomain())) {
                    return -1;
                }
            }
            return nameComp;
        }
    }
}

