/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.io;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CopyUtil {
    private static final int BUFFER_SIZE = 8192;
    private static Logger logger = LoggerFactory.getLogger(CopyUtil.class);

    private CopyUtil() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean copy(String source, String target) {
        try (FileInputStream fis = new FileInputStream(source);){
            boolean bl;
            try (FileOutputStream fos = new FileOutputStream(target);){
                CopyUtil.copy(fis, fos);
                bl = true;
            }
            return bl;
        }
        catch (IOException e) {
            logger.error("File '{}' could not be copied to '{}'", new Object[]{source, target, e});
            return false;
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
            out.flush();
        }
    }
}

