/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.io;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileUtil {
    public static final String FILE_SEPERATOR = System.getProperty("file.separator");
    public static final String FILE_SEPERATOR_WINDOWS = "\\";
    public static final char FILE_SEPERATOR_CHAR_WINDOWS = '\\';
    public static final String FILE_SEPERATOR_LINUX = "/";
    public static final char FILE_SEPERATOR_CHAR_LINUX = '/';
    public static final int WINDOWS_MAX_PATH_LENGTH = 259;
    public static final int WINDOWS_MIN_FILENAME_LENGTH = 12;
    public static final int WINDOWS_MAX_FOLDER_PATH_LENGTH = 247;
    public static final int PATH_WITHOUT_FILENAME_LENGTH_LIMIT = 139;
    public static final int FILENAME_LENGTH_LIMIT = 108;
    private static final Pattern PATTERN_WINDOWS_DRIVE_LETTER = Pattern.compile("^[a-zA-Z]:\\\\.*");
    private static final Pattern RELATIVE_PATH_COMPONENT_REMOVAL_PATTERN = Pattern.compile("\\.[\\\\/]");
    public static final int FILENAME_ASCII_ONLY = 0;
    public static final int FILENAME_ASCII_UMLAUT = 1;
    public static final int FILENAME_ALL = 2;
    private static Pattern lTrimPatternPath = Pattern.compile("^[\\s\\.]+");
    private static Pattern rTrimPatternPath = Pattern.compile("[\\s\\.]+$");
    private static Pattern patternZeroFilledNumber = Pattern.compile("#+");
    private static FilenameFilter filenameAsciiOnlyFilter = new FilenameAsciiOnlyFilter();
    private static FilenameFilter filenameAsciiUmlautFilter = new FilenameAsciiUmlautFilter();
    private static FilenameFilter filenameAllFilter = new FilenameFilter();

    private FileUtil() {
    }

    private static int getLastSeperatorPos(String file) {
        if (file == null || file.isEmpty()) {
            return -1;
        }
        int posBackslash = file.lastIndexOf(92);
        int posSlash = file.lastIndexOf(47);
        if (posBackslash < 0 && posSlash < 0) {
            return -1;
        }
        return posBackslash > posSlash ? posBackslash : posSlash;
    }

    public static String getDirectory(String file) {
        if (file == null) {
            return "";
        }
        int pos = FileUtil.getLastSeperatorPos(file);
        if (pos > -1) {
            return file.substring(0, pos + 1);
        }
        return "";
    }

    public static String getFilename(String file) {
        if (file == null) {
            return file;
        }
        int pos = FileUtil.getLastSeperatorPos(file);
        if (pos > -1) {
            return file.substring(pos + 1);
        }
        return file;
    }

    private static int getLastDotPos(String file) {
        if (file == null || file.isEmpty()) {
            return -1;
        }
        return file.lastIndexOf(".");
    }

    private static int getFileExtensionDotPos(String file) {
        int posPathSeparator;
        int posDot = FileUtil.getLastDotPos(file);
        if (posDot > -1 && ((posPathSeparator = FileUtil.getLastSeperatorPos(file)) < 0 || posDot > posPathSeparator)) {
            return posDot;
        }
        return -1;
    }

    public static String getFileExtension(String file) {
        int pos = FileUtil.getFileExtensionDotPos(file);
        if (pos > -1) {
            return file.substring(pos + 1);
        }
        return "";
    }

    public static String getFilePrefix(String file) {
        String filename = FileUtil.getFilename(file);
        if (filename == null) {
            return file;
        }
        int pos = FileUtil.getLastDotPos(filename);
        if (pos > 0) {
            return filename.substring(0, pos);
        }
        return filename;
    }

    public static String getPathFromFile(File file) {
        if (file.isDirectory()) {
            return file.getAbsolutePath();
        }
        return FileUtil.getDirectory(file.getAbsolutePath());
    }

    public static boolean checkIsSameOrSubFolder(String path, String parentPath) {
        File folderPath = new File(path);
        File folderParentPath = new File(parentPath);
        Object absolutPath = folderPath.getAbsolutePath();
        Object absolutParentPath = folderParentPath.getAbsolutePath();
        if (PATTERN_WINDOWS_DRIVE_LETTER.matcher((CharSequence)absolutPath).matches()) {
            absolutPath = ((String)absolutPath).toLowerCase();
        }
        if (PATTERN_WINDOWS_DRIVE_LETTER.matcher((CharSequence)absolutParentPath).matches()) {
            absolutParentPath = ((String)absolutParentPath).toLowerCase();
        }
        absolutPath = RELATIVE_PATH_COMPONENT_REMOVAL_PATTERN.matcher((CharSequence)absolutPath).replaceAll("");
        absolutParentPath = RELATIVE_PATH_COMPONENT_REMOVAL_PATTERN.matcher((CharSequence)absolutParentPath).replaceAll("");
        if (!((String)absolutPath).endsWith(FILE_SEPERATOR)) {
            absolutPath = (String)absolutPath + FILE_SEPERATOR;
        }
        if (!((String)absolutParentPath).endsWith(FILE_SEPERATOR)) {
            absolutParentPath = (String)absolutParentPath + FILE_SEPERATOR;
        }
        return ((String)absolutPath).startsWith((String)absolutParentPath);
    }

    public static synchronized String lTrim(String str) {
        return lTrimPatternPath.matcher(str).replaceAll("");
    }

    public static synchronized String rTrim(String str) {
        return rTrimPatternPath.matcher(str).replaceAll("");
    }

    public static String pathRTrim(String path) {
        boolean endsWithPathSeparator;
        if (path.isEmpty()) {
            return path;
        }
        char lastCharacter = path.charAt(path.length() - 1);
        boolean bl = endsWithPathSeparator = lastCharacter == '\\' || lastCharacter == '/';
        if (endsWithPathSeparator) {
            String pathWihtoutSeparator = path.substring(0, path.length() - 1);
            return FileUtil.rTrim(pathWihtoutSeparator) + lastCharacter;
        }
        return FileUtil.rTrim(path);
    }

    public static String getNumberedFilename(String filename, int number) {
        if (!filename.contains("#")) {
            return filename;
        }
        StringBuffer sb = new StringBuffer();
        Matcher matcher = patternZeroFilledNumber.matcher(filename);
        while (matcher.find()) {
            String replacement = FileUtil.getZeroFilledNumber(number, matcher.group().length());
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String getZeroFilledNumber(int number, int len) {
        String strNumber = String.valueOf(number);
        int numberLen = strNumber.length();
        if (len == numberLen) {
            return strNumber;
        }
        if (len < numberLen) {
            len = numberLen;
        }
        char[] chars = new char[len - numberLen];
        Arrays.fill(chars, '0');
        String zeroFilledPrefix = new String(chars);
        return zeroFilledPrefix + strNumber;
    }

    public static String reducePathLength(String folder) {
        return FileUtil.reducePathLength(folder, 139);
    }

    public static String reducePathLength(String folder, int lengthLimit) {
        int folderLength = folder.length();
        if (folderLength <= lengthLimit) {
            return folder;
        }
        char lastCharacter = folder.charAt(folderLength - 1);
        boolean endsWithPathSeparator = lastCharacter == '\\' || lastCharacter == '/';
        int limit = endsWithPathSeparator ? lengthLimit - 1 : lengthLimit;
        if (limit > folder.length()) {
            limit = folder.length();
        }
        String reducedPath = folder.substring(0, limit);
        String trimmedPath = FileUtil.pathRTrim(reducedPath);
        if (endsWithPathSeparator) {
            return trimmedPath + lastCharacter;
        }
        return trimmedPath;
    }

    public static String reduceFilenameLength(String filename) {
        return FileUtil.reduceFilenameLength(filename, 108);
    }

    public static String reduceFilenameLength(String filename, int lengthLimit) {
        if (filename.length() <= lengthLimit) {
            return filename;
        }
        String filenamePrefix = FileUtil.getFilePrefix(filename);
        String ext = FileUtil.getFileExtension(filename);
        int extLength = !ext.isEmpty() ? ext.length() + 1 : 0;
        int limit = lengthLimit - extLength;
        if (limit < 1) {
            limit = 1;
        }
        if (limit > filenamePrefix.length()) {
            limit = filenamePrefix.length();
        }
        String result = filenamePrefix.substring(0, limit);
        if (!ext.isEmpty()) {
            return result + "." + ext;
        }
        return result;
    }

    public static String reduceTextLength(String text, int limit) {
        if (limit < 0 || limit > text.length()) {
            return text;
        }
        return text.substring(0, limit);
    }

    private static String filterPath(String str, boolean noPath, int mode) {
        FilenameFilter filenameFilter = mode == 0 ? filenameAsciiOnlyFilter : (mode == 1 ? filenameAsciiUmlautFilter : filenameAllFilter);
        return filenameFilter.filter(str, noPath);
    }

    public static String filterPath(String path, int mode) {
        return FileUtil.filterPath(path, false, mode);
    }

    public static String filterFilename(String filename, int mode) {
        return FileUtil.filterPath(filename, true, mode);
    }

    private static class FilenameAsciiUmlautFilter
    extends FilenameFilter {
        public FilenameAsciiUmlautFilter() {
            this.patterns.put(Pattern.compile("[^\\x20-\\x7E\\xA0-\\xFF]"), "");
        }
    }

    private static class FilenameAsciiOnlyFilter
    extends FilenameFilter {
        public FilenameAsciiOnlyFilter() {
            this.patterns.put(Pattern.compile("[\u00f6]"), "oe");
            this.patterns.put(Pattern.compile("[\u00f2\u00f3\u00f4\u00f5]"), "o");
            this.patterns.put(Pattern.compile("[\u00d6]"), "OE");
            this.patterns.put(Pattern.compile("[\u00d2\u00d3\u00d4\u00d5]"), "O");
            this.patterns.put(Pattern.compile("[\u00e4]"), "ae");
            this.patterns.put(Pattern.compile("[\u00e0\u00e1\u00e2\u00e3\u00e5]"), "a");
            this.patterns.put(Pattern.compile("[\u00c4]"), "AE");
            this.patterns.put(Pattern.compile("[\u00c0\u00c1\u00c2\u00c3\u00c5]"), "A");
            this.patterns.put(Pattern.compile("[\u00fc]"), "ue");
            this.patterns.put(Pattern.compile("[\u00f9\u00fa\u00fb\u00b5]"), "u");
            this.patterns.put(Pattern.compile("[\u00dc]"), "UE");
            this.patterns.put(Pattern.compile("[\u00d9\u00da\u00db]"), "U");
            this.patterns.put(Pattern.compile("[\u00e8\u00e9\u00ea\u00eb]"), "e");
            this.patterns.put(Pattern.compile("[\u00c8\u00c9\u00ca\u00cb]"), "E");
            this.patterns.put(Pattern.compile("[\u00ec\u00ed\u00ee\u00ef]"), "i");
            this.patterns.put(Pattern.compile("[\u00cc\u00cd\u00ce\u00cf]"), "I");
            this.patterns.put(Pattern.compile("[\u00df]"), "ss");
            this.patterns.put(Pattern.compile("[^\\x20-\\x7E]"), "");
        }
    }

    private static class FilenameFilter {
        protected final Pattern notAllowedFilenameCharsPattern = Pattern.compile("[\"*<>?|/:\\\\]");
        protected final Pattern notAllowedFolderCharsPattern = Pattern.compile("[\"*<>?|]");
        protected final Map<Pattern, String> patterns = new LinkedHashMap<Pattern, String>();

        private FilenameFilter() {
        }

        public String filter(String filename, boolean noPath) {
            Object result = this.filterSpecialPatterns(filename);
            result = ((String)result).replace("\"", "'");
            if (noPath) {
                result = this.notAllowedFilenameCharsPattern.matcher((CharSequence)result).replaceAll("");
            } else {
                Matcher matcherWindowsDriveLetter = PATTERN_WINDOWS_DRIVE_LETTER.matcher((CharSequence)(result = this.notAllowedFolderCharsPattern.matcher((CharSequence)result).replaceAll("")));
                if (matcherWindowsDriveLetter.matches()) {
                    String driveLetter = ((String)result).substring(0, 2);
                    String remainingPath = ((String)result).substring(2);
                    remainingPath = remainingPath.replace(":", "");
                    result = driveLetter + remainingPath;
                }
            }
            return result;
        }

        private String filterSpecialPatterns(String filename) {
            String result = filename;
            for (Map.Entry<Pattern, String> entry : this.patterns.entrySet()) {
                result = entry.getKey().matcher(result).replaceAll(entry.getValue());
            }
            return result;
        }
    }
}

