/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.settings;

import ch.supertomcat.supertomcatutils.application.ApplicationUtil;
import ch.supertomcat.supertomcatutils.io.CopyUtil;
import ch.supertomcat.supertomcatutils.settings.SettingsListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class SettingsManagerBase<T, L extends SettingsListener> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final JAXBContext jaxbContext;
    protected T settings = null;
    protected final File settingsFolder;
    protected final File settingsFile;
    protected final File settingsBackupFile;
    protected final String defaultSettingsResourcePath;
    protected final String settingsSchemaResourcePath;
    protected List<L> listeners = new CopyOnWriteArrayList<L>();

    protected SettingsManagerBase(Class<?> objectFactoryClass, String defaultSettingsResourcePath, String settingsSchemaResourcePath) throws JAXBException {
        this.settingsFolder = null;
        this.settingsFile = null;
        this.settingsBackupFile = null;
        this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{objectFactoryClass});
        this.defaultSettingsResourcePath = defaultSettingsResourcePath;
        this.settingsSchemaResourcePath = settingsSchemaResourcePath;
    }

    public SettingsManagerBase(String strSettingsFolder, String strSettingsFilename, Class<?> objectFactoryClass, String defaultSettingsResourcePath, String settingsSchemaResourcePath) throws JAXBException {
        this.settingsFolder = new File(strSettingsFolder);
        this.settingsFile = new File(this.settingsFolder, strSettingsFilename);
        this.settingsBackupFile = new File(this.settingsFolder, strSettingsFilename + ".backup");
        this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{objectFactoryClass});
        this.defaultSettingsResourcePath = defaultSettingsResourcePath;
        this.settingsSchemaResourcePath = settingsSchemaResourcePath;
        this.createDirectoryIfNotExists(this.settingsFolder);
        if (!this.settingsFile.exists()) {
            this.logger.info("Settingsfile not found in folder '{}': {}", (Object)this.settingsFolder.getAbsolutePath(), (Object)this.settingsFile.getAbsolutePath());
            this.restoreSettingsFileFromBackupFile();
        } else if (this.settingsFile.length() == 0L) {
            this.logger.error("Settingsfile is empty: {}", (Object)this.settingsFile.getAbsolutePath());
            this.restoreSettingsFileFromBackupFile();
        } else {
            long now = System.currentTimeMillis();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd--HH-mm-ss-SSS");
            String target = this.settingsFile.getAbsolutePath() + "-" + dateFormat.format(now);
            CopyUtil.copy(this.settingsFile.getAbsolutePath(), target);
            ApplicationUtil.deleteOldBackupFiles(this.settingsFolder, strSettingsFilename, 3);
            if (!this.settingsBackupFile.exists()) {
                this.backupSettingsFile();
            }
        }
    }

    protected synchronized boolean restoreSettingsFileFromBackupFile() {
        if (this.settingsBackupFile.exists() && this.settingsBackupFile.length() > 0L) {
            this.logger.info("Restoring Settingsfile with backup: {}", (Object)this.settingsBackupFile.getAbsolutePath());
            CopyUtil.copy(this.settingsBackupFile.getAbsolutePath(), this.settingsFile.getAbsolutePath());
            return true;
        }
        return false;
    }

    protected synchronized boolean backupSettingsFile() {
        if (this.settingsFile.exists() && this.settingsFile.length() > 0L) {
            this.logger.debug("Backing up Settingsfile: {}", (Object)this.settingsBackupFile.getAbsolutePath());
            CopyUtil.copy(this.settingsFile.getAbsolutePath(), this.settingsBackupFile.getAbsolutePath());
            return true;
        }
        return false;
    }

    protected boolean createDirectoryIfNotExists(File directory) {
        if (!directory.exists()) {
            try {
                Files.createDirectories(directory.toPath(), new FileAttribute[0]);
                return true;
            }
            catch (IOException e) {
                this.logger.error("Settings-Folder could not be created: {}", (Object)directory.getAbsolutePath(), (Object)e);
                return false;
            }
        }
        return true;
    }

    protected synchronized T loadUserSettingsFile() throws IOException, SAXException, JAXBException {
        try (FileInputStream in = new FileInputStream(this.settingsFile);){
            T t = this.loadSettingsFile(in, false);
            return t;
        }
    }

    protected synchronized T loadDefaultSettingsFile() throws IOException, SAXException, JAXBException {
        try (InputStream in = this.getClass().getResourceAsStream(this.defaultSettingsResourcePath);){
            if (in == null) {
                throw new IllegalArgumentException("Resource not found: " + this.defaultSettingsResourcePath);
            }
            T t = this.loadSettingsFile(in, true);
            return t;
        }
    }

    protected synchronized T loadSettingsFile(InputStream in, boolean validateSchema) throws SAXException, JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        if (validateSchema) {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(this.getClass().getResource(this.settingsSchemaResourcePath));
            unmarshaller.setSchema(schema);
        }
        return (T)unmarshaller.unmarshal(in);
    }

    protected synchronized void writeSettingsFile(T settings, OutputStream out, boolean validateSchema) throws SAXException, JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        if (validateSchema) {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(this.getClass().getResource(this.settingsSchemaResourcePath));
            marshaller.setSchema(schema);
        }
        marshaller.marshal(settings, out);
    }

    protected void settingsChanged() {
        for (SettingsListener listener : this.listeners) {
            listener.settingsChanged();
        }
    }

    public void addSettingsListener(L l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeSettingsListener(L l) {
        this.listeners.remove(l);
    }

    public T getSettings() {
        return this.settings;
    }
}

