/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.application;

import ch.supertomcat.supertomcatutils.application.ApplicationProperties;
import ch.supertomcat.supertomcatutils.exceptionhandler.SLF4JUncaughtExceptionHandler;
import java.awt.Image;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.channels.FileLock;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationUtil {
    private static FileLock lockFile = null;

    private ApplicationUtil() {
    }

    public static String getThisApplicationsPath(String jarFilename) {
        String classpath = System.getProperty("java.class.path");
        if (classpath.contains(";")) {
            String[] paths = classpath.split(";");
            Pattern p = Pattern.compile("(?i)(.+?)[/\\\\]bin$");
            for (String path : paths) {
                File f;
                Matcher m = p.matcher(path);
                if (!m.matches() || !(f = new File(m.replaceAll("$1"))).exists()) continue;
                String rootPath = f.getPath() + System.getProperty("file.separator");
                System.out.println("Rootpath of application detected: " + rootPath);
                return rootPath;
            }
        } else {
            File f;
            Pattern p = Pattern.compile("(?i)(.+?)[/\\\\]" + jarFilename + "$");
            Matcher m = p.matcher(classpath);
            if (classpath.equalsIgnoreCase(jarFilename)) {
                return "./";
            }
            if (m.matches() && (f = new File(m.replaceAll("$1"))).exists()) {
                String rootPath = f.getPath() + System.getProperty("file.separator");
                System.out.println("Rootpath of application detected: " + rootPath);
                return rootPath;
            }
        }
        return "./";
    }

    public static String getThisApplicationsJarFilename(Class<?> classInJarFile) {
        try {
            File jarFile = new File(classInJarFile.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            if (jarFile.isFile()) {
                System.out.println("Jar-Filename detected: " + jarFile.getName());
                return jarFile.getName();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        System.err.println("Could not detect Jar-Filename");
        return "";
    }

    public static int compareVersions(String v1, String v2) {
        String[] strV1 = v1.split("\\.");
        String[] strV2 = v2.split("\\.");
        int diff = strV1.length - strV2.length;
        int len = strV1.length;
        if (diff < 0) {
            len = strV2.length;
        }
        int[] strV1C = new int[len];
        int[] strV2C = new int[len];
        try {
            int a;
            for (a = 0; a < len; ++a) {
                strV1C[a] = strV1.length <= a ? 0 : Integer.parseInt(strV1[a]);
            }
            for (a = 0; a < len; ++a) {
                strV2C[a] = strV2.length <= a ? 0 : Integer.parseInt(strV2[a]);
            }
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
        for (int i = 0; i < len; ++i) {
            int comp = Integer.compare(strV1C[i], strV2C[i]);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public static synchronized boolean lockLockFile(String strLockFilePath, String strLockFilename) {
        Logger logger = LoggerFactory.getLogger(ApplicationUtil.class);
        File folder = new File(strLockFilePath);
        if (!folder.exists() && !folder.mkdirs()) {
            logger.error("Could not create directory: {}", (Object)folder.getAbsolutePath());
            return false;
        }
        File file = new File(strLockFilePath, strLockFilename);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    logger.error("Could not create Lock-File: {}", (Object)file.getAbsolutePath());
                    return false;
                }
            }
            catch (IOException e) {
                logger.error("Could not create Lock-File: {}", (Object)file.getAbsolutePath(), (Object)e);
                return false;
            }
        }
        try {
            lockFile = new RandomAccessFile(file, "rw").getChannel().tryLock();
            return lockFile != null;
        }
        catch (IOException e) {
            logger.error("Could not lock Lock-File: {}", (Object)file.getAbsolutePath(), (Object)e);
            return false;
        }
    }

    public static synchronized boolean releaseLockFile() {
        if (lockFile != null) {
            try {
                lockFile.release();
                lockFile = null;
                return true;
            }
            catch (IOException e) {
                Logger logger = LoggerFactory.getLogger(ApplicationUtil.class);
                logger.error("Could not release Lock-File", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static synchronized FileLock getLockFile() {
        return lockFile;
    }

    public static void deleteOldLogFiles(int days, String logFileName, String logPath) {
        Logger logger = LoggerFactory.getLogger(ApplicationUtil.class);
        final Pattern patternLogFiles = Pattern.compile(logFileName + "\\.([0-9]{4}-[0-9]{2}-[0-9]{2})");
        File logDir = new File(logPath);
        if (logDir.exists() && logDir.isDirectory()) {
            File[] logFiles = logDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return patternLogFiles.matcher(name).matches();
                }
            });
            if (logFiles == null) {
                logger.error("Could not get file list of directory: {}", (Object)logDir.getAbsolutePath());
                return;
            }
            long millisecondsPerDay = 86400000L;
            Date beforeXDays = new Date(new Date().getTime() - 86400000L * (long)days);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            for (File logFile : logFiles) {
                try {
                    Matcher matcher = patternLogFiles.matcher(logFile.getName());
                    String strDateOfFile = matcher.replaceAll("$1");
                    Date dateOfFile = df.parse(strDateOfFile);
                    if (!beforeXDays.after(dateOfFile) || logFile.delete()) continue;
                    logger.error("Could not delete old Log-File: {}", (Object)logFile.getAbsolutePath());
                }
                catch (NumberFormatException | ParseException e) {
                    logger.error("Could not check Log-File: {}", (Object)logFile.getAbsolutePath(), (Object)e);
                }
            }
        }
    }

    public static void initializeSLF4JUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new SLF4JUncaughtExceptionHandler());
    }

    public static void logApplicationInfo() {
        Logger logger = LoggerFactory.getLogger(ApplicationUtil.class);
        logger.info("{} {}, Java-Version: {}, Java-Vendor: {}, OS: {} {} {}, Processors: {}, VM Max Memory: {}", new Object[]{ApplicationProperties.getProperty("ApplicationName"), ApplicationProperties.getProperty("ApplicationVersion"), System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().maxMemory()});
    }

    public static void writeBasicErrorLogfile(File file, String errorMessage) {
        try (FileOutputStream out = new FileOutputStream(file, true);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));){
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateTime = dateFormat.format(new Date());
            bw.write(dateTime + ": " + errorMessage);
            bw.flush();
        }
        catch (IOException e) {
            System.err.println("Could not write error log file: " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    public static void deleteOldBackupFiles(File folder, final String filename, int daysToKeepBackup) {
        final Logger logger = LoggerFactory.getLogger(ApplicationUtil.class);
        final long now = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.add(5, -daysToKeepBackup);
        final Date backupDeleteDate = cal.getTime();
        final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd--HH-mm-ss-SSS");
        final long backupDeleteTime = (long)(daysToKeepBackup * 24 * 60 * 60) * 1000L;
        File[] backupFiles = folder.listFiles(new FileFilter(){
            private final Pattern oldBackupPattern;
            private final Pattern backupPattern;
            {
                this.oldBackupPattern = Pattern.compile("^" + filename + ".bak-([0-9]+)$");
                this.backupPattern = Pattern.compile("^" + filename + "-([0-9]{4}-[0-9]{2}-[0-9]{2}--[0-9]{2}-[0-9]{2}-[0-9]{2}-[0-9]{3})$");
            }

            @Override
            public boolean accept(File pathname) {
                Matcher matcher = this.backupPattern.matcher(pathname.getName());
                if (matcher.matches()) {
                    try {
                        Date backupDate = dateFormat.parse(matcher.group(1));
                        if (backupDate.before(backupDeleteDate)) {
                            return true;
                        }
                    }
                    catch (ParseException e) {
                        logger.error("Could not parse datetime of backup file: {}", (Object)pathname.getAbsolutePath(), (Object)e);
                    }
                    return false;
                }
                matcher = this.oldBackupPattern.matcher(pathname.getName());
                if (matcher.matches()) {
                    try {
                        long backupTime = Long.parseLong(matcher.group(1));
                        if (now - backupTime > backupDeleteTime) {
                            return true;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Could not parse datetime of backup file: {}", (Object)pathname.getAbsolutePath(), (Object)nfe);
                    }
                    return false;
                }
                return false;
            }
        });
        if (backupFiles != null) {
            for (File oldBackupFile : backupFiles) {
                if (oldBackupFile.delete()) continue;
                logger.error("Could not delete old backup file: {}", (Object)oldBackupFile.getAbsolutePath());
            }
        }
    }

    public static JFrame createInvisibleFrame(String title) {
        return ApplicationUtil.createInvisibleFrame(title, null);
    }

    public static JFrame createInvisibleFrame(String title, Image icon) {
        JFrame frame = new JFrame(title);
        frame.setIconImage(icon);
        frame.setUndecorated(true);
        frame.setVisible(true);
        frame.setLocationRelativeTo(null);
        return frame;
    }

    public static String formatStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }
}

