/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.database.sqlite;

import ch.supertomcat.supertomcatutils.application.ApplicationProperties;
import ch.supertomcat.supertomcatutils.application.ApplicationUtil;
import ch.supertomcat.supertomcatutils.gui.Localization;
import ch.supertomcat.supertomcatutils.io.CopyUtil;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SQLiteDB<T> {
    private static final String VACUUM_SQL_COMMAND = "VACUUM";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String databaseFile;
    protected final String tableName;

    public SQLiteDB(String databaseFile, String tableName, boolean backupDatabaseOnStart, boolean defragDatabaseOnStart, long defragMinFileSize) {
        File dbFile;
        this.databaseFile = databaseFile;
        this.tableName = tableName;
        this.createFolderIfNotExist();
        if (backupDatabaseOnStart) {
            this.backupDatabase();
        }
        boolean openDBFailed = false;
        try (Connection con = this.getDatabaseConnection();){
            con.close();
        }
        catch (ClassNotFoundException | SQLException e) {
            openDBFailed = true;
            String databaseAbsolutePath = new File(databaseFile).getAbsolutePath();
            String dbError = String.format(Localization.getString("ErrorDBNotOpen"), databaseAbsolutePath);
            JOptionPane.showMessageDialog(null, dbError + "\n" + e.getMessage(), "Database-Error", 0);
            this.logger.error("Database could not be opened: {}", (Object)databaseAbsolutePath, (Object)e);
        }
        if (openDBFailed) {
            System.exit(0);
        }
        if (defragDatabaseOnStart && (dbFile = new File(databaseFile)).exists() && dbFile.length() >= defragMinFileSize) {
            this.defragDatabase();
        }
    }

    public String getDatabaseFile() {
        return this.databaseFile;
    }

    public String getTableName() {
        return this.tableName;
    }

    private void createFolderIfNotExist() {
        File folder = new File(ApplicationProperties.getProperty("DatabasePath"));
        if (!folder.exists() && !folder.mkdirs()) {
            this.logger.error("Could not create database folder: {}", (Object)folder.getAbsolutePath());
        }
    }

    private void backupDatabase() {
        long now = System.currentTimeMillis();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd--HH-mm-ss-SSS");
        String target = this.databaseFile + "-" + dateFormat.format(now);
        File dbFile = new File(this.databaseFile);
        String dbFilename = dbFile.getName();
        if (dbFile.exists()) {
            CopyUtil.copy(this.databaseFile, target);
        }
        ApplicationUtil.deleteOldBackupFiles(new File(ApplicationProperties.getProperty("DatabasePath")), dbFilename, 3);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean defragDatabase() {
        try (Connection con = this.getDatabaseConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = con.prepareStatement(VACUUM_SQL_COMMAND);
                try {
                    statement.executeUpdate();
                    bl = true;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (ClassNotFoundException | SQLException e) {
            this.logger.error("Could not fragement database '{}'", (Object)this.databaseFile, (Object)e);
            return false;
        }
    }

    public void closeAllDatabaseConnections() {
    }

    protected Connection getDatabaseConnection() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.JDBC");
        return DriverManager.getConnection("jdbc:sqlite:" + this.databaseFile);
    }

    protected abstract boolean createDatabaseIfNotExist();

    protected abstract T convertResultSetToObject(ResultSet var1) throws SQLException, JAXBException;

    public abstract List<T> getAllEntries();

    public abstract T getEntry(int var1);

    public abstract boolean insertEntry(T var1);

    public abstract boolean insertEntries(List<T> var1);

    public abstract boolean updateEntry(T var1);

    public abstract boolean updateEntries(List<T> var1);

    public abstract boolean deleteEntry(T var1);

    public abstract boolean deleteEntries(List<T> var1);
}

