/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui;

import ch.supertomcat.supertomcatutils.image.ImageSizeWaiter;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BaseMultiResolutionImage;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Icons {
    private static final String APPL_ICON_RESOURCE_FORMAT = "/" + Icons.class.getPackage().getName().replace(".", "/") + "/icons/%s";
    private static final String APPL_ICON_SIZE_RESOURCE_FORMAT = "/" + Icons.class.getPackage().getName().replace(".", "/") + "/icons/%dx%d/%s";
    private static final String TANGO_ICON_RESOURCE_FORMAT = "/org/freedesktop/tango/%dx%d/%s";
    private static final int[] TANGO_ICON_SIZES = new int[]{16, 22, 32};
    private static final int[] APPL_ICON_SIZES = new int[]{16, 22, 32, 64, 128, 256};
    private static final Component MEDIA_TRACKER_COMPONENT = new Component(){
        private static final long serialVersionUID = 1L;
    };
    private static final MediaTracker MEDIA_TRACKER = new MediaTracker(MEDIA_TRACKER_COMPONENT);
    private static int mediaTrackerID = 0;
    private static Map<String, Image> imageCache = new HashMap<String, Image>();
    private static Set<String> notFoundImages = new HashSet<String>();
    private static Logger logger = LoggerFactory.getLogger(Icons.class);
    private static Image dummy16 = Icons.getApplImage("dummy.png", 16);
    private static Image dummy22 = Icons.getApplImage("dummy.png", 22);
    private static Image dummy32 = Icons.getApplImage("dummy.png", 32);

    private Icons() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNextMediaTrackerID() {
        MediaTracker mediaTracker = MEDIA_TRACKER;
        synchronized (mediaTracker) {
            return ++mediaTrackerID;
        }
    }

    public static ImageIcon getTangoIcon(String resource, int size) {
        return Icons.getIcon(String.format(TANGO_ICON_RESOURCE_FORMAT, size, size, resource));
    }

    public static ImageIcon getTangoMultiResIcon(String resource) {
        return new ImageIcon(Icons.getTangoMultiResImage(resource));
    }

    public static ImageIcon getTangoMultiResIcon(String resource, int size) {
        return new ImageIcon(Icons.getTangoMultiResImage(resource, size));
    }

    public static Image getTangoMultiResImage(String resource) {
        return Icons.getTangoMultiResImage(resource, 16);
    }

    public static Image getTangoMultiResImage(String resource, int size) {
        int resourceCount = TANGO_ICON_SIZES.length;
        if (IntStream.of(TANGO_ICON_SIZES).noneMatch(x -> x == size)) {
            ++resourceCount;
        }
        String[] resources = new String[resourceCount];
        resources[0] = String.format(TANGO_ICON_RESOURCE_FORMAT, size, size, resource);
        String[] tempArr = (String[])IntStream.of(TANGO_ICON_SIZES).filter(x -> x != size).mapToObj(x -> String.format(TANGO_ICON_RESOURCE_FORMAT, x, x, resource)).toArray(String[]::new);
        System.arraycopy(tempArr, 0, resources, 1, tempArr.length);
        return Icons.getMultiResImage(resources);
    }

    public static Image getTangoImage(String resource, int size) {
        return Icons.getImage(String.format(TANGO_ICON_RESOURCE_FORMAT, size, size, resource));
    }

    public static ImageIcon getApplIcon(String resource) {
        return Icons.getIcon(String.format(APPL_ICON_RESOURCE_FORMAT, resource));
    }

    public static ImageIcon getApplIcon(String resource, int size) {
        return Icons.getIcon(String.format(APPL_ICON_SIZE_RESOURCE_FORMAT, size, size, resource));
    }

    public static ImageIcon getApplMultiResIcon(String resource) {
        return new ImageIcon(Icons.getApplMultiResImage(resource));
    }

    public static ImageIcon getApplMultiResIcon(String resource, int size) {
        return new ImageIcon(Icons.getApplMultiResImage(resource, size));
    }

    public static Image getApplMultiResImage(String resource) {
        return Icons.getApplMultiResImage(resource, 16);
    }

    public static Image getApplMultiResImage(String resource, int size) {
        int resourceCount = APPL_ICON_SIZES.length;
        if (IntStream.of(APPL_ICON_SIZES).noneMatch(x -> x == size)) {
            ++resourceCount;
        }
        String[] resources = new String[resourceCount];
        resources[0] = String.format(APPL_ICON_SIZE_RESOURCE_FORMAT, size, size, resource);
        String[] tempArr = (String[])IntStream.of(APPL_ICON_SIZES).filter(x -> x != size).mapToObj(x -> String.format(APPL_ICON_SIZE_RESOURCE_FORMAT, x, x, resource)).toArray(String[]::new);
        System.arraycopy(tempArr, 0, resources, 1, tempArr.length);
        return Icons.getMultiResImage(resources);
    }

    public static Image getApplImage(String resource) {
        return Icons.getImage(String.format(APPL_ICON_RESOURCE_FORMAT, resource));
    }

    public static Image getApplImage(String resource, int size) {
        return Icons.getImage(String.format(APPL_ICON_SIZE_RESOURCE_FORMAT, size, size, resource));
    }

    public static ImageIcon getIcon(String resource) {
        return new ImageIcon(Icons.getImage(resource));
    }

    public static ImageIcon getMultiResIcon(String ... resources) {
        return new ImageIcon(Icons.getMultiResImage(resources));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getMultiResImage(String ... resources) {
        Image[] images = new Image[resources.length];
        int loadedImages = 0;
        MediaTracker mediaTracker = MEDIA_TRACKER;
        synchronized (mediaTracker) {
            for (int i = 0; i < resources.length; ++i) {
                boolean first = i == 0;
                int id = Icons.getNextMediaTrackerID();
                Image loadedImage = Icons.getImage(resources[i], null, first);
                if (loadedImage == null) continue;
                MEDIA_TRACKER.addImage(images[i], id);
                try {
                    MEDIA_TRACKER.waitForID(id, 0L);
                }
                catch (InterruptedException e) {
                    logger.error("Wait for media tracker was interrupted", (Throwable)e);
                }
                MEDIA_TRACKER.removeImage(images[i], id);
                ImageSizeWaiter imageSizeWaiter = new ImageSizeWaiter(loadedImage);
                if (!imageSizeWaiter.waitForSize(500L)) {
                    logger.warn("Image size not yet available: {}", (Object)resources[i]);
                }
                images[loadedImages] = loadedImage;
                ++loadedImages;
            }
        }
        if (loadedImages == 0) {
            return dummy16;
        }
        if (loadedImages != images.length) {
            Image[] tempArr = new Image[loadedImages];
            System.arraycopy(images, 0, tempArr, 0, loadedImages);
            images = tempArr;
        }
        return new BaseMultiResolutionImage(images);
    }

    public static Image getImage(String resource) {
        return Icons.getImage(resource, dummy16, true);
    }

    public static Image getImage(String resource, Image defaultValue) {
        return Icons.getImage(resource, defaultValue, true);
    }

    public static synchronized Image getImage(String resource, Image defaultValue, boolean logError) {
        Image image = imageCache.get(resource);
        if (image != null) {
            return image;
        }
        if (notFoundImages.contains(resource)) {
            return defaultValue;
        }
        image = Icons.loadImage(resource, logError);
        if (image != null) {
            imageCache.put(resource, image);
            return image;
        }
        notFoundImages.add(resource);
        return defaultValue;
    }

    private static Image loadImage(String resource, boolean logError) {
        try {
            URL resourceURL = Icons.class.getResource(resource);
            if (resourceURL != null) {
                return Toolkit.getDefaultToolkit().getImage(resourceURL);
            }
            if (logError) {
                logger.error("Could not load image: {}", (Object)resource);
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Could not load image: {}", (Object)resource, (Object)e);
            return null;
        }
    }

    public static Image getDummyImage(int size) {
        if (size >= 32) {
            return dummy32;
        }
        if (size >= 22 && size < 32) {
            return dummy22;
        }
        return dummy16;
    }
}

