/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.combobox.renderer;

import ch.supertomcat.supertomcatutils.gui.Localization;
import java.awt.Component;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class LocalizedEnumComboBoxRenderer<T extends Enum<T>>
extends BasicComboBoxRenderer {
    private static final long serialVersionUID = 1L;
    private Class<T> enumClass;
    private Map<T, String> localizedStrings;

    public LocalizedEnumComboBoxRenderer(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public LocalizedEnumComboBoxRenderer(Class<T> enumClass, Map<T, String> localizedStrings) {
        this.enumClass = enumClass;
        this.localizedStrings = localizedStrings;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (comp instanceof JLabel && this.enumClass.isInstance(value)) {
            Enum enumValue = (Enum)this.enumClass.cast(value);
            if (this.localizedStrings != null) {
                String localizationString = this.localizedStrings.get(enumValue);
                if (localizationString != null) {
                    ((JLabel)comp).setText(Localization.getString(localizationString));
                }
            } else {
                ((JLabel)comp).setText(Localization.getString(enumValue.name()));
            }
        }
        return comp;
    }
}

