/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.dialog.about;

import ch.supertomcat.supertomcatutils.application.libraries.LibraryInfo;
import ch.supertomcat.supertomcatutils.application.libraries.LibraryInfoUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class AboutDialogLibrariesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JTextPane txtAboutLibs = new JTextPane();

    public AboutDialogLibrariesPanel() {
        this.setLayout(new BorderLayout());
        this.txtAboutLibs.setEditable(false);
        FontMetrics fontMetrics = this.txtAboutLibs.getFontMetrics(this.txtAboutLibs.getFont());
        int fontHeight = fontMetrics.getLeading() + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        this.txtAboutLibs.setPreferredSize(new Dimension(100 * fontMetrics.charWidth('A'), 25 * fontHeight));
        this.add((Component)new JScrollPane(this.txtAboutLibs), "Center");
        this.prepareLibInformation();
    }

    protected void prepareLibInformation() {
        StringBuilder sbLibInformation = new StringBuilder();
        ArrayList<Point> boldPositions = new ArrayList<Point>();
        this.fillLibInformation(sbLibInformation, boldPositions);
        this.txtAboutLibs.setText(sbLibInformation.toString());
        for (Point p : boldPositions) {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            StyleConstants.setBold(sas, true);
            this.txtAboutLibs.getStyledDocument().setCharacterAttributes(p.x, p.y, sas, false);
        }
        this.txtAboutLibs.setCaretPosition(0);
    }

    protected void fillLibInformation(StringBuilder sbLibInformation, List<Point> boldPositions) {
        for (LibraryInfo libInfo : LibraryInfoUtil.getLibraries()) {
            int startPos = sbLibInformation.length();
            int length = libInfo.getName().length();
            boldPositions.add(new Point(startPos, length));
            sbLibInformation.append(libInfo.getName());
            if (!libInfo.getVersion().isEmpty()) {
                sbLibInformation.append("\nVersion: ");
                sbLibInformation.append(libInfo.getVersion());
            }
            if (!libInfo.getLicense().isEmpty()) {
                sbLibInformation.append("\nLicense: ");
                sbLibInformation.append(libInfo.getLicense());
            }
            sbLibInformation.append("\n\n");
        }
    }
}

