/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.formatter;

import java.text.DecimalFormat;

public final class UnitFormatUtil {
    public static final int PROGRESSBAR_PERCENT = 0;
    public static final int PROGRESSBAR_SIZE = 1;
    public static final int NOPROGRESSBAR_PERCENT = 2;
    public static final int NOPROGRESSBAR_SIZE = 3;
    public static final int AUTO_CHANGE_SIZE = 0;
    public static final int ONLY_B = 1;
    public static final int ONLY_KIB = 2;
    public static final int ONLY_MIB = 3;
    public static final int ONLY_GIB = 4;
    public static final int ONLY_TIB = 5;
    private static final String[] SIZE_UNITS = new String[]{"B", "KiB", "MiB", "GiB", "TiB"};
    private static final String[] BITRATE_UNITS = new String[]{"B/s", "KiB/s", "MiB/s", "GiB/s", "TiB/s"};

    private UnitFormatUtil() {
    }

    public static String getSizeString(long size, int mode) {
        int c;
        double sizec = size;
        int limit = SIZE_UNITS.length - 1;
        if (mode > 0 && mode <= SIZE_UNITS.length) {
            limit = mode - 1;
        }
        if (mode > 0) {
            for (c = 0; c < limit; ++c) {
                sizec /= 1024.0;
            }
        } else {
            while (sizec > 1024.0 && c < limit) {
                sizec /= 1024.0;
                ++c;
            }
        }
        sizec = (double)Math.round(sizec * 100.0) / 100.0;
        return new DecimalFormat("0.##").format(sizec) + " " + SIZE_UNITS[c];
    }

    public static String getPercentString(long size, long max) {
        return (int)((double)size / (double)max * 100.0) + "%";
    }

    public static double getBitrate(long size, long max, long timeStarted, long timeNow) {
        if (max >= size) {
            long milliSecondsPassed = timeNow - timeStarted;
            if (milliSecondsPassed <= 0L) {
                return -1.0;
            }
            double secondsPassed = (double)milliSecondsPassed / 1000.0;
            if (secondsPassed < 1.0) {
                return 1000.0 * (double)size / (double)milliSecondsPassed;
            }
            return (double)size / secondsPassed;
        }
        return -1.0;
    }

    public static String getBitrateString(double rate) {
        int c;
        if (rate < 0.0) {
            return "";
        }
        for (c = 0; rate > 1024.0 && c < BITRATE_UNITS.length - 1; rate /= 1024.0, ++c) {
        }
        if (c >= 2) {
            return (double)Math.round(rate * 100.0) / 100.0 + " " + BITRATE_UNITS[c];
        }
        return (long)Math.rint(rate) + " " + BITRATE_UNITS[c];
    }
}

